/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg;

import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.description.DescribedEnum;
import org.apache.paimon.options.description.InlineElement;
import org.apache.paimon.options.description.TextElement;

public class IcebergOptions {
    public static final ConfigOption<StorageType> METADATA_ICEBERG_STORAGE = ConfigOptions.key((String)"metadata.iceberg.storage").enumType(StorageType.class).defaultValue((Object)StorageType.DISABLED).withDescription("When set, produce Iceberg metadata after a snapshot is committed, so that Iceberg readers can read Paimon's raw data files.");
    public static final ConfigOption<StorageLocation> METADATA_ICEBERG_STORAGE_LOCATION = ConfigOptions.key((String)"metadata.iceberg.storage-location").enumType(StorageLocation.class).noDefaultValue().withDescription("To store Iceberg metadata in a separate directory or under table location");
    public static final ConfigOption<Integer> FORMAT_VERSION = ConfigOptions.key((String)"metadata.iceberg.format-version").intType().defaultValue((Object)2).withDescription("The format version of iceberg table, the value can be 2 or 3. Note that only version 3 supports deletion vector.");
    public static final ConfigOption<Integer> COMPACT_MIN_FILE_NUM = ConfigOptions.key((String)"metadata.iceberg.compaction.min.file-num").intType().defaultValue((Object)10).withDescription("Minimum number of Iceberg manifest metadata files to trigger manifest metadata compaction.");
    public static final ConfigOption<Integer> COMPACT_MAX_FILE_NUM = ConfigOptions.key((String)"metadata.iceberg.compaction.max.file-num").intType().defaultValue((Object)50).withDescription("If number of small Iceberg manifest metadata files exceeds this limit, always trigger manifest metadata compaction regardless of their total size.");
    public static final ConfigOption<Boolean> METADATA_DELETE_AFTER_COMMIT = ConfigOptions.key((String)"metadata.iceberg.delete-after-commit.enabled").booleanType().defaultValue((Object)true).withDescription("Whether to delete old metadata files after each table commit");
    public static final ConfigOption<Integer> METADATA_PREVIOUS_VERSIONS_MAX = ConfigOptions.key((String)"metadata.iceberg.previous-versions-max").intType().defaultValue((Object)0).withDescription("The number of old metadata files to keep after each table commit");
    public static final ConfigOption<String> URI = ConfigOptions.key((String)"metadata.iceberg.uri").stringType().noDefaultValue().withDescription("Hive metastore uri for Iceberg Hive catalog.");
    public static final ConfigOption<String> HIVE_CONF_DIR = ConfigOptions.key((String)"metadata.iceberg.hive-conf-dir").stringType().noDefaultValue().withDescription("hive-conf-dir for Iceberg Hive catalog.");
    public static final ConfigOption<String> HADOOP_CONF_DIR = ConfigOptions.key((String)"metadata.iceberg.hadoop-conf-dir").stringType().noDefaultValue().withDescription("hadoop-conf-dir for Iceberg Hive catalog.");
    public static final ConfigOption<String> MANIFEST_COMPRESSION = ConfigOptions.key((String)"metadata.iceberg.manifest-compression").stringType().defaultValue((Object)"snappy").withDescription("Compression for Iceberg manifest files.");
    public static final ConfigOption<Boolean> MANIFEST_LEGACY_VERSION = ConfigOptions.key((String)"metadata.iceberg.manifest-legacy-version").booleanType().defaultValue((Object)false).withDescription("Should use the legacy manifest version to generate Iceberg's 1.4 manifest files.");
    public static final ConfigOption<String> HIVE_CLIENT_CLASS = ConfigOptions.key((String)"metadata.iceberg.hive-client-class").stringType().defaultValue((Object)"org.apache.hadoop.hive.metastore.HiveMetaStoreClient").withDescription("Hive client class name for Iceberg Hive Catalog.");
    public static final ConfigOption<String> METASTORE_DATABASE = ConfigOptions.key((String)"metadata.iceberg.database").stringType().noDefaultValue().withDescription("Metastore database name for Iceberg Catalog. Set this as an iceberg database alias if using a centralized Catalog.");
    public static final ConfigOption<String> METASTORE_TABLE = ConfigOptions.key((String)"metadata.iceberg.table").stringType().noDefaultValue().withDescription("Metastore table name for Iceberg Catalog.Set this as an iceberg table alias if using a centralized Catalog.");
    public static final ConfigOption<Boolean> GLUE_SKIP_ARCHIVE = ConfigOptions.key((String)"metadata.iceberg.glue.skip-archive").booleanType().defaultValue((Object)false).withDescription("Skip archive for AWS Glue catalog.");
    public static final ConfigOption<Boolean> HIVE_SKIP_UPDATE_STATS = ConfigOptions.key((String)"metadata.iceberg.hive-skip-update-stats").booleanType().defaultValue((Object)false).withDescription("Skip updating Hive stats.");

    public static enum StorageLocation implements DescribedEnum
    {
        TABLE_LOCATION("table-location", "Store Iceberg metadata in each table's directory. Useful for standalone Iceberg tables or Java API access. Can also be used with Hive Catalog"),
        CATALOG_STORAGE("catalog-location", "Store Iceberg metadata in a separate directory. Allows integration with Hive Catalog or Hadoop Catalog.");

        private final String value;
        private final String description;

        private StorageLocation(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        public InlineElement getDescription() {
            return TextElement.text((String)this.description);
        }
    }

    public static enum StorageType implements DescribedEnum
    {
        DISABLED("disabled", "Disable Iceberg compatibility support."),
        TABLE_LOCATION("table-location", "Store Iceberg metadata in each table's directory."),
        HADOOP_CATALOG("hadoop-catalog", "Store Iceberg metadata in a separate directory. This directory can be specified as the warehouse directory of an Iceberg Hadoop catalog."),
        HIVE_CATALOG("hive-catalog", "Not only store Iceberg metadata like hadoop-catalog, but also create Iceberg external table in Hive.");

        private final String value;
        private final String description;

        private StorageType(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        public InlineElement getDescription() {
            return TextElement.text((String)this.description);
        }
    }
}

