/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.paimon.Changelog;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.manifest.ExpireFileEntry;
import org.apache.paimon.operation.SnapshotDeletion;
import org.apache.paimon.options.ExpireConfig;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireSnapshotsImpl
implements ExpireSnapshots {
    private static final Logger LOG = LoggerFactory.getLogger(ExpireSnapshotsImpl.class);
    private final SnapshotManager snapshotManager;
    private final ChangelogManager changelogManager;
    private final ConsumerManager consumerManager;
    private final SnapshotDeletion snapshotDeletion;
    private final TagManager tagManager;
    private ExpireConfig expireConfig;

    public ExpireSnapshotsImpl(SnapshotManager snapshotManager, ChangelogManager changelogManager, SnapshotDeletion snapshotDeletion, TagManager tagManager) {
        this.snapshotManager = snapshotManager;
        this.changelogManager = changelogManager;
        this.consumerManager = new ConsumerManager(snapshotManager.fileIO(), snapshotManager.tablePath(), snapshotManager.branch());
        this.snapshotDeletion = snapshotDeletion;
        this.tagManager = tagManager;
        this.expireConfig = ExpireConfig.builder().build();
    }

    @Override
    public ExpireSnapshots config(ExpireConfig expireConfig) {
        this.expireConfig = expireConfig;
        return this;
    }

    @Override
    public int expire() {
        this.snapshotDeletion.setChangelogDecoupled(this.expireConfig.isChangelogDecoupled());
        int retainMax = this.expireConfig.getSnapshotRetainMax();
        int retainMin = this.expireConfig.getSnapshotRetainMin();
        int maxDeletes = this.expireConfig.getSnapshotMaxDeletes();
        long olderThanMills = System.currentTimeMillis() - this.expireConfig.getSnapshotTimeRetain().toMillis();
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        if (latestSnapshotId == null) {
            return 0;
        }
        Long earliest = this.snapshotManager.earliestSnapshotId();
        if (earliest == null) {
            return 0;
        }
        Preconditions.checkArgument((retainMax >= retainMin ? 1 : 0) != 0, (Object)String.format("retainMax (%s) must not be less than retainMin (%s).", retainMax, retainMin));
        long min = Math.max(latestSnapshotId - (long)retainMax + 1L, earliest);
        long maxExclusive = latestSnapshotId - (long)retainMin + 1L;
        maxExclusive = Math.min(maxExclusive, this.consumerManager.minNextSnapshot().orElse(Long.MAX_VALUE));
        maxExclusive = Math.min(maxExclusive, earliest + (long)maxDeletes);
        for (long id = min; id < maxExclusive; ++id) {
            if (!this.snapshotManager.snapshotExists(id) || olderThanMills > this.snapshotManager.snapshot(id).timeMillis()) continue;
            return this.expireUntil(earliest, id);
        }
        return this.expireUntil(earliest, maxExclusive);
    }

    @VisibleForTesting
    public int expireUntil(long earliestId, long endExclusiveId) {
        Snapshot snapshot;
        Snapshot snapshot2;
        long id;
        long startTime = System.currentTimeMillis();
        if (endExclusiveId <= earliestId) {
            if (this.snapshotManager.earliestFileNotExists()) {
                this.writeEarliestHint(earliestId);
            }
            return 0;
        }
        long beginInclusiveId = earliestId;
        for (long id2 = endExclusiveId - 1L; id2 >= earliestId; --id2) {
            if (this.snapshotManager.snapshotExists(id2)) continue;
            beginInclusiveId = id2 + 1L;
            break;
        }
        List<Snapshot> taggedSnapshots = this.tagManager.taggedSnapshots();
        for (id = beginInclusiveId + 1L; id <= endExclusiveId; ++id) {
            Predicate<ExpireFileEntry> skipper;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete merge tree files not used by snapshot #" + id);
            }
            try {
                snapshot2 = this.snapshotManager.tryGetSnapshot(id);
            }
            catch (FileNotFoundException e) {
                beginInclusiveId = id + 1L;
                continue;
            }
            try {
                skipper = this.snapshotDeletion.createDataFileSkipperForTags(taggedSnapshots, id);
            }
            catch (Exception e) {
                LOG.info(String.format("Skip cleaning data files of snapshot '%s' due to failed to build skipping set.", id), (Throwable)e);
                continue;
            }
            this.snapshotDeletion.cleanUnusedDataFiles(snapshot2, skipper);
        }
        if (!this.expireConfig.isChangelogDecoupled()) {
            for (id = beginInclusiveId; id < endExclusiveId; ++id) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ready to delete changelog files from snapshot #" + id);
                }
                try {
                    snapshot2 = this.snapshotManager.tryGetSnapshot(id);
                }
                catch (FileNotFoundException e) {
                    beginInclusiveId = id + 1L;
                    continue;
                }
                if (snapshot2.changelogManifestList() == null) continue;
                this.snapshotDeletion.deleteAddedDataFiles(snapshot2.changelogManifestList());
            }
        }
        this.snapshotDeletion.cleanEmptyDirectories();
        List<Snapshot> skippingSnapshots = ExpireSnapshotsImpl.findSkippingTags(taggedSnapshots, beginInclusiveId, endExclusiveId);
        try {
            skippingSnapshots.add(this.snapshotManager.tryGetSnapshot(endExclusiveId));
        }
        catch (FileNotFoundException e) {
            return 0;
        }
        HashSet<String> skippingSet = null;
        try {
            skippingSet = new HashSet<String>(this.snapshotDeletion.manifestSkippingSet(skippingSnapshots));
        }
        catch (Exception e) {
            LOG.info("Skip cleaning manifest files due to failed to build skipping set.", (Throwable)e);
        }
        if (skippingSet != null) {
            for (long id3 = beginInclusiveId; id3 < endExclusiveId; ++id3) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ready to delete manifests in snapshot #" + id3);
                }
                try {
                    snapshot = this.snapshotManager.tryGetSnapshot(id3);
                }
                catch (FileNotFoundException e) {
                    beginInclusiveId = id3 + 1L;
                    continue;
                }
                this.snapshotDeletion.cleanUnusedManifests(snapshot, (Set<String>)skippingSet);
            }
        }
        for (long id4 = beginInclusiveId; id4 < endExclusiveId; ++id4) {
            try {
                snapshot = this.snapshotManager.tryGetSnapshot(id4);
            }
            catch (FileNotFoundException e) {
                beginInclusiveId = id4 + 1L;
                continue;
            }
            if (this.expireConfig.isChangelogDecoupled()) {
                this.commitChangelog(new Changelog(snapshot));
            }
            this.snapshotManager.deleteSnapshot(id4);
        }
        this.writeEarliestHint(endExclusiveId);
        long duration = System.currentTimeMillis() - startTime;
        LOG.info("Finished expire snapshots, duration {} ms, range is [{}, {})", new Object[]{duration, beginInclusiveId, endExclusiveId});
        return (int)(endExclusiveId - beginInclusiveId);
    }

    private void commitChangelog(Changelog changelog) {
        try {
            this.changelogManager.commitChangelog(changelog, changelog.id());
            this.changelogManager.commitLongLivedChangelogLatestHint(changelog.id());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeEarliestHint(long earliest) {
        try {
            this.snapshotManager.commitEarliestHint(earliest);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @VisibleForTesting
    public SnapshotDeletion snapshotDeletion() {
        return this.snapshotDeletion;
    }

    public static List<Snapshot> findSkippingTags(List<Snapshot> sortedTags, long beginInclusive, long endExclusive) {
        ArrayList<Snapshot> overlappedSnapshots = new ArrayList<Snapshot>();
        int right = SnapshotManager.findPreviousSnapshot(sortedTags, endExclusive);
        if (right >= 0) {
            int left;
            for (int i = left = Math.max(SnapshotManager.findPreviousOrEqualSnapshot(sortedTags, beginInclusive), 0); i <= right; ++i) {
                overlappedSnapshots.add(sortedTags.get(i));
            }
        }
        return overlappedSnapshots;
    }
}

