/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;

public class ConsumersTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String CONSUMERS = "consumers";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "consumer_id", (DataType)SerializationUtils.newStringType(false)), new DataField(1, "next_snapshot_id", (DataType)new BigIntType(false))));
    private final FileIO fileIO;
    private final Path location;
    private final String branch;
    private final FileStoreTable dataTable;

    public ConsumersTable(FileStoreTable dataTable) {
        this.fileIO = dataTable.fileIO();
        this.location = dataTable.location();
        this.branch = CoreOptions.branch((Map)dataTable.schema().options());
        this.dataTable = dataTable;
    }

    @Override
    public String name() {
        return this.location.getName() + "$" + CONSUMERS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("consumer_id");
    }

    @Override
    public FileIO fileIO() {
        return this.dataTable.fileIO();
    }

    @Override
    public InnerTableScan newScan() {
        return new ConsumersScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new ConsumersRead(this.fileIO);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new ConsumersTable((FileStoreTable)this.dataTable.copy((Map)dynamicOptions));
    }

    private class ConsumersRead
    implements InnerTableRead {
        private final FileIO fileIO;
        private RowType readType;

        public ConsumersRead(FileIO fileIO) {
            this.fileIO = fileIO;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            this.readType = readType;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            if (!(split instanceof ConsumersSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Path location = ((ConsumersSplit)split).location;
            Map<String, Long> consumers = new ConsumerManager(this.fileIO, location, ConsumersTable.this.branch).consumers();
            Iterator rows = Iterators.transform(consumers.entrySet().iterator(), this::toRow);
            if (this.readType != null) {
                rows = Iterators.transform((Iterator)rows, row -> ProjectedRow.from((RowType)this.readType, (RowType)TABLE_TYPE).replaceRow(row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private InternalRow toRow(Map.Entry<String, Long> consumer) {
            return GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)consumer.getKey()), consumer.getValue()});
        }
    }

    private static class ConsumersSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;
        private final Path location;

        private ConsumersSplit(Path location) {
            this.location = location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsumersSplit that = (ConsumersSplit)o;
            return Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class ConsumersScan
    extends ReadOnceTableScan {
        private ConsumersScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new ConsumersSplit(ConsumersTable.this.location));
        }
    }
}

