/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.paimon.Snapshot;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.tag.Tag;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemBranchManager
implements BranchManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemBranchManager.class);
    private final FileIO fileIO;
    private final Path tablePath;
    private final SnapshotManager snapshotManager;
    private final TagManager tagManager;
    private final SchemaManager schemaManager;

    public FileSystemBranchManager(FileIO fileIO, Path path, SnapshotManager snapshotManager, TagManager tagManager, SchemaManager schemaManager) {
        this.fileIO = fileIO;
        this.tablePath = path;
        this.snapshotManager = snapshotManager;
        this.tagManager = tagManager;
        this.schemaManager = schemaManager;
    }

    private Path branchDirectory() {
        return new Path(this.tablePath + "/branch");
    }

    public Path branchPath(String branchName) {
        return new Path(BranchManager.branchPath(this.tablePath, branchName));
    }

    @Override
    public void createBranch(String branchName) {
        this.validateBranch(branchName);
        try {
            TableSchema latestSchema = this.schemaManager.latest().get();
            this.copySchemasToBranch(branchName, latestSchema.id());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception occurs when create branch '%s' (directory in %s).", branchName, BranchManager.branchPath(this.tablePath, branchName)), e);
        }
    }

    @Override
    public void createBranch(String branchName, String tagName) {
        this.validateBranch(branchName);
        Snapshot snapshot = this.tagManager.getOrThrow(tagName).trimToSnapshot();
        try {
            this.fileIO.copyFile(this.tagManager.tagPath(tagName), this.tagManager.copyWithBranch(branchName).tagPath(tagName), true);
            this.fileIO.copyFile(this.snapshotManager.snapshotPath(snapshot.id()), this.snapshotManager.copyWithBranch(branchName).snapshotPath(snapshot.id()), true);
            this.copySchemasToBranch(branchName, snapshot.schemaId());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception occurs when create branch '%s' (directory in %s).", branchName, BranchManager.branchPath(this.tablePath, branchName)), e);
        }
    }

    @Override
    public void dropBranch(String branchName) {
        Preconditions.checkArgument((boolean)this.branchExists(branchName), (String)"Branch name '%s' doesn't exist.", (Object[])new Object[]{branchName});
        try {
            this.fileIO.delete(this.branchPath(branchName), true);
        }
        catch (IOException e) {
            LOG.info(String.format("Deleting the branch failed due to an exception in deleting the directory %s. Please try again.", BranchManager.branchPath(this.tablePath, branchName)), (Throwable)e);
        }
    }

    private boolean fileExists(Path path) {
        try {
            return this.fileIO.exists(path);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to determine if path '%s' exists.", path), e);
        }
    }

    @Override
    public void fastForward(String branchName) {
        BranchManager.fastForwardValidate(branchName, this.snapshotManager.branch());
        Preconditions.checkArgument((boolean)this.branchExists(branchName), (String)"Branch name '%s' doesn't exist.", (Object[])new Object[]{branchName});
        Long earliestSnapshotId = this.snapshotManager.copyWithBranch(branchName).earliestSnapshotId();
        if (earliestSnapshotId == null) {
            throw new RuntimeException("Cannot fast forward branch " + branchName + ", because it does not have snapshot.");
        }
        Snapshot earliestSnapshot = this.snapshotManager.copyWithBranch(branchName).snapshot(earliestSnapshotId);
        long earliestSchemaId = earliestSnapshot.schemaId();
        try {
            List<Path> deleteSnapshotPaths = this.snapshotManager.snapshotPaths(id -> id >= earliestSnapshotId);
            List<Path> deleteSchemaPaths = this.schemaManager.schemaPaths(id -> id >= earliestSchemaId);
            List<Path> deleteTagPaths = this.tagManager.tagPaths(path -> Tag.fromPath(this.fileIO, path).id() >= earliestSnapshotId);
            List deletePaths = Stream.of(deleteSnapshotPaths, deleteSchemaPaths, deleteTagPaths).flatMap(Collection::stream).collect(Collectors.toList());
            this.snapshotManager.deleteLatestHint();
            this.fileIO.deleteFilesQuietly(deletePaths);
            this.fileIO.copyFiles(this.snapshotManager.copyWithBranch(branchName).snapshotDirectory(), this.snapshotManager.snapshotDirectory(), true);
            this.fileIO.copyFiles(this.schemaManager.copyWithBranch(branchName).schemaDirectory(), this.schemaManager.schemaDirectory(), true);
            this.fileIO.copyFiles(this.tagManager.copyWithBranch(branchName).tagDirectory(), this.tagManager.tagDirectory(), true);
            this.snapshotManager.invalidateCache();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception occurs when fast forward '%s' (directory in %s).", branchName, BranchManager.branchPath(this.tablePath, branchName)), e);
        }
    }

    @Override
    public boolean branchExists(String branchName) {
        Path branchPath = this.branchPath(branchName);
        return this.fileExists(branchPath);
    }

    @Override
    public void validateBranch(String branchName) {
        BranchManager.validateBranch(branchName);
        Preconditions.checkArgument((!this.branchExists(branchName) ? 1 : 0) != 0, (String)"Branch name '%s' already exists.", (Object[])new Object[]{branchName});
    }

    @Override
    public List<String> branches() {
        try {
            return FileUtils.listVersionedDirectories(this.fileIO, this.branchDirectory(), "branch-").map(status -> status.getPath().getName().substring("branch-".length())).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void copySchemasToBranch(String branchName, long schemaId) throws IOException {
        int i = 0;
        while ((long)i <= schemaId) {
            if (this.schemaManager.schemaExists(i)) {
                this.fileIO.copyFile(this.schemaManager.toSchemaPath(i), this.schemaManager.copyWithBranch(branchName).toSchemaPath(i), true);
            }
            ++i;
        }
    }
}

