/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hive;

import org.apache.gravitino.catalog.hive.HiveTableOperations;
import org.apache.gravitino.connector.BaseTable;
import org.apache.gravitino.connector.TableOperations;
import org.apache.gravitino.hive.CachedClientPool;
import org.apache.gravitino.hive.HiveTable;
import org.apache.gravitino.rel.SupportsPartitions;

public class HiveTableHandle
extends BaseTable {
    private final HiveTable table;
    private final CachedClientPool clientPool;

    public HiveTableHandle(HiveTable hiveTable, CachedClientPool clientPool) {
        this.table = hiveTable;
        this.clientPool = clientPool;
        this.name = hiveTable.name();
        this.comment = hiveTable.comment();
        this.properties = hiveTable.properties();
        this.auditInfo = hiveTable.auditInfo();
        this.columns = hiveTable.columns();
        this.partitioning = hiveTable.partitioning();
        this.sortOrders = hiveTable.sortOrder();
        this.distribution = hiveTable.distribution();
        this.indexes = hiveTable.index();
        this.proxyPlugin = hiveTable.proxyPlugin();
    }

    public HiveTable table() {
        return this.table;
    }

    public CachedClientPool clientPool() {
        return this.clientPool;
    }

    protected TableOperations newOps() {
        return new HiveTableOperations(this);
    }

    public SupportsPartitions supportPartitions() throws UnsupportedOperationException {
        return (SupportsPartitions)this.ops();
    }

    public void close() {
        this.clientPool.close();
    }

    public String getTableType() {
        return this.properties.getOrDefault("table-type", "MANAGED_TABLE");
    }

    public String toString() {
        return "HiveTableHandle(table=" + String.valueOf(this.table) + ", clientPool=" + String.valueOf(this.clientPool) + ")";
    }
}

