/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import com.google.common.base.Preconditions;
import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.GravitinoConfig;

public class CommandContext {
    private final boolean force;
    private final boolean ignoreVersions;
    private final String outputFormat;
    private final String url;
    private final boolean quiet;
    private final CommandLine line;
    private final String auth;
    private String ignoreEnv;
    private boolean ignoreSet = false;
    private String urlEnv;
    private boolean urlSet = false;
    private String authEnv;
    private boolean authSet = false;

    public CommandContext(CommandLine line) {
        Preconditions.checkArgument(line != null, "line cannot be null");
        this.line = line;
        this.force = line.hasOption("force");
        this.outputFormat = line.hasOption("output") ? line.getOptionValue("output") : "plain";
        this.quiet = line.hasOption("quiet");
        this.url = this.getUrl();
        this.ignoreVersions = this.getIgnore();
        this.auth = this.getAuth();
    }

    public String url() {
        return this.url;
    }

    public boolean ignoreVersions() {
        return this.ignoreVersions;
    }

    public boolean force() {
        return this.force;
    }

    public String outputFormat() {
        return this.outputFormat;
    }

    public boolean quiet() {
        return this.quiet;
    }

    public String auth() {
        return this.auth;
    }

    public CommandLine line() {
        return this.line;
    }

    private String getUrl() {
        GravitinoConfig config = new GravitinoConfig(null);
        if (this.line.hasOption("url")) {
            return this.line.getOptionValue("url");
        }
        if (this.urlEnv == null && !this.urlSet) {
            this.urlEnv = System.getenv("GRAVITINO_URL");
            this.urlSet = true;
        }
        if (this.urlEnv != null) {
            return this.urlEnv;
        }
        if (config.fileExists()) {
            config.read();
            String configURL = config.getGravitinoURL();
            if (configURL != null) {
                return configURL;
            }
        }
        return "http://localhost:8090";
    }

    private boolean getIgnore() {
        GravitinoConfig config = new GravitinoConfig(null);
        boolean ignore = false;
        if (this.line.hasOption("ignore")) {
            ignore = true;
        } else {
            if (this.ignoreEnv == null && !this.ignoreSet) {
                this.ignoreEnv = System.getenv("GRAVITINO_IGNORE");
                ignore = this.ignoreEnv != null && this.ignoreEnv.equals("true");
                this.ignoreSet = true;
            }
            if (this.ignoreEnv == null && config.fileExists()) {
                config.read();
                ignore = config.getIgnore();
            }
        }
        return ignore;
    }

    private String getAuth() {
        if (this.line.hasOption("simple")) {
            return "simple";
        }
        if (this.authEnv == null && !this.authSet) {
            this.authEnv = System.getenv("GRAVITINO_AUTH");
            this.authSet = true;
        }
        if (this.authEnv != null) {
            return this.authEnv;
        }
        GravitinoConfig config = new GravitinoConfig(null);
        if (config.fileExists()) {
            config.read();
            String configAuthType = config.getGravitinoAuthType();
            if (configAuthType != null) {
                return configAuthType;
            }
        }
        return null;
    }
}

