/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.cli.AreYouSure;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoAdminClient;
import org.apache.gravitino.exceptions.MetalakeInUseException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class DeleteMetalake
extends Command {
    protected final String metalake;
    protected final boolean force;

    public DeleteMetalake(CommandContext context, String metalake) {
        super(context);
        this.force = context.force();
        this.metalake = metalake;
    }

    @Override
    public void handle() {
        boolean deleted = false;
        if (!AreYouSure.really(this.force)) {
            return;
        }
        try {
            GravitinoAdminClient client = this.buildAdminClient();
            deleted = client.dropMetalake(this.metalake);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (MetalakeInUseException inUseException) {
            System.err.println(this.metalake + " in use, please disable it first.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (deleted) {
            this.printInformation(this.metalake + " deleted.");
        } else {
            this.printInformation(this.metalake + " not deleted.");
        }
    }
}

