/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Arrays;
import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.ModelVersionAliasesAlreadyExistException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.model.ModelCatalog;

public class LinkModel
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String model;
    protected final Map<String, String> uris;
    protected final String[] alias;
    protected final String comment;
    protected final Map<String, String> properties;

    public LinkModel(CommandContext context, String metalake, String catalog, String schema, String model, Map<String, String> uris, String[] alias, String comment, Map<String, String> properties) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.model = model;
        this.uris = uris;
        this.alias = alias;
        this.comment = comment;
        this.properties = properties;
    }

    @Override
    public void handle() {
        NameIdentifier name = NameIdentifier.of(this.schema, this.model);
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            ModelCatalog modelCatalog = client.loadCatalog(this.catalog).asModelCatalog();
            modelCatalog.linkModelVersion(name, this.uris, this.alias, this.comment, this.properties);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchModelException err) {
            this.exitWithError("Unknown model name.");
        }
        catch (ModelVersionAliasesAlreadyExistException err) {
            this.exitWithError(Arrays.toString(this.alias) + " already exist.");
        }
        catch (Exception err) {
            this.exitWithError(err.getMessage());
        }
        this.printResults("Linked model " + this.model + " to " + String.valueOf(this.uris) + " with aliases " + Arrays.toString(this.alias));
    }

    @Override
    public Command validate() {
        if (this.uris == null || this.uris.isEmpty()) {
            this.exitWithError("Missing --uris option.");
        }
        return super.validate();
    }
}

