/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.Audit;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class ListRoles
extends Command {
    protected String metalake;

    public ListRoles(CommandContext context, String metalake) {
        super(context);
        this.metalake = metalake;
    }

    @Override
    public void handle() {
        String[] roles = new String[]{};
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            roles = client.listRoleNames();
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (roles.length == 0) {
            this.printInformation("No roles exist.");
        } else {
            Role[] roleObjects = (Role[])Arrays.stream(roles).map(this::getRole).toArray(Role[]::new);
            this.printResults(roleObjects);
        }
    }

    private Role getRole(final String name) {
        return new Role(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public Map<String, String> properties() {
                return null;
            }

            @Override
            public List<SecurableObject> securableObjects() {
                return null;
            }

            @Override
            public Audit auditInfo() {
                return null;
            }
        };
    }
}

