/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.Metalake;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoAdminClient;
import org.apache.gravitino.client.GravitinoMetalake;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class ManageMetalake
extends Command {
    private final String metalake;
    private final CommandLine line;
    private Boolean enableAllCatalogs;

    public ManageMetalake(CommandContext context, String metalake) {
        super(context);
        this.metalake = metalake;
        this.line = context.line();
        this.enableAllCatalogs = this.line.hasOption("all");
    }

    @Override
    public void handle() {
        if (this.line.hasOption("enable")) {
            this.enableMetalake();
        } else if (this.line.hasOption("disable")) {
            this.disableMetalake();
        }
    }

    @Override
    public Command validate() {
        if (this.line.hasOption("enable") && this.line.hasOption("disable")) {
            this.exitWithError("Unable to use --enable and --disable at the same time.");
        }
        return super.validate();
    }

    private void enableMetalake() {
        StringBuilder msgBuilder = new StringBuilder(this.metalake);
        try {
            GravitinoAdminClient client = this.buildAdminClient();
            client.enableMetalake(this.metalake);
            msgBuilder.append(" has been enabled.");
            if (this.enableAllCatalogs.booleanValue()) {
                Metalake metalakeObject = client.loadMetalake(this.metalake);
                String[] catalogs = ((GravitinoMetalake)metalakeObject).listCatalogs();
                Arrays.stream(catalogs).forEach(((GravitinoMetalake)metalakeObject)::enableCatalog);
                msgBuilder.append(" and all catalogs in this metalake have been enabled.");
            }
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(msgBuilder.toString());
    }

    private void disableMetalake() {
        try {
            GravitinoAdminClient client = this.buildAdminClient();
            client.disableMetalake(this.metalake);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.metalake + " has been disabled.");
    }
}

