/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.List;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchGroupException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchUserException;

public class RemoveAllRoles
extends Command {
    protected final String metalake;
    protected final String entity;
    protected final String entityType;

    public RemoveAllRoles(CommandContext context, String metalake, String entity, String entityType) {
        super(context);
        this.metalake = metalake;
        this.entity = entity;
        this.entityType = entityType;
    }

    @Override
    public void handle() {
        if ("group".equals(this.entityType)) {
            this.revokeAllRolesFromGroup();
        } else {
            this.revokeAllRolesFromUser();
        }
    }

    private void revokeAllRolesFromGroup() {
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            Group group = client.getGroup(this.entity);
            List<String> roles = group.roles();
            client.revokeRolesFromGroup(roles, this.entity);
        }
        catch (NoSuchMetalakeException e) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchGroupException e) {
            this.exitWithError("Unknown group.");
        }
        catch (Exception e) {
            this.exitWithError(e.getMessage());
        }
        this.printInformation("All roles have been revoked from group " + this.entity);
    }

    private void revokeAllRolesFromUser() {
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            User user = client.getUser(this.entity);
            List<String> roles = user.roles();
            client.revokeRolesFromUser(roles, this.entity);
        }
        catch (NoSuchMetalakeException e) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchUserException e) {
            this.exitWithError("Unknown user.");
        }
        catch (Exception e) {
            this.exitWithError(e.getMessage());
        }
        this.printInformation("All roles have been revoked from user " + this.entity);
    }
}

