/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class SetOwner
extends Command {
    protected final String metalake;
    protected final String entity;
    protected final MetadataObject.Type entityType;
    protected final String owner;
    protected final boolean isGroup;

    public SetOwner(CommandContext context, String metalake, String entity, String entityType, String owner, boolean isGroup) {
        super(context);
        this.metalake = metalake;
        this.entity = entity;
        this.owner = owner;
        this.isGroup = isGroup;
        this.entityType = entityType.equals("metalake") ? MetadataObject.Type.METALAKE : (entityType.equals("catalog") ? MetadataObject.Type.CATALOG : (entityType.equals("schema") ? MetadataObject.Type.SCHEMA : (entityType.equals("table") ? MetadataObject.Type.TABLE : (entityType.equals("column") ? MetadataObject.Type.COLUMN : (entityType.equals("topic") ? MetadataObject.Type.TOPIC : (entityType.equals("fileset") ? MetadataObject.Type.FILESET : null))))));
    }

    @Override
    public void handle() {
        MetadataObject metadata = MetadataObjects.parse(this.entity, this.entityType);
        Owner.Type ownerType = this.isGroup ? Owner.Type.GROUP : Owner.Type.USER;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            client.setOwner(metadata, this.owner, ownerType);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchMetadataObjectException err) {
            this.exitWithError("Unknown entity.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation("Set owner to " + this.owner);
    }

    @Override
    public Command validate() {
        if (this.entityType == null) {
            System.err.println("Unknown entity.");
            throw new RuntimeException();
        }
        return super.validate();
    }
}

