/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;

public class SetSchemaProperty
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String property;
    protected final String value;

    public SetSchemaProperty(CommandContext context, String metalake, String catalog, String schema, String property, String value) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.property = property;
        this.value = value;
    }

    @Override
    public void handle() {
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            SchemaChange change = SchemaChange.setProperty(this.property, this.value);
            client.loadCatalog(this.catalog).asSchemas().alterSchema(this.schema, change);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        System.out.println(this.schema + " property set.");
    }

    @Override
    public Command validate() {
        this.validatePropertyAndValue(this.property, this.value);
        return this;
    }
}

