/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.PositionConverter;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchColumnException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.rel.TableChange;

public class UpdateColumnPosition
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String table;
    protected final String column;
    protected final String position;

    public UpdateColumnPosition(CommandContext context, String metalake, String catalog, String schema, String table, String column, String position) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.table = table;
        this.column = column;
        this.position = position;
    }

    @Override
    public void handle() {
        String[] columns = new String[]{this.column};
        try {
            NameIdentifier columnName = NameIdentifier.of(this.schema, this.table);
            GravitinoClient client = this.buildClient(this.metalake);
            TableChange change = TableChange.updateColumnPosition(columns, PositionConverter.convert(this.position));
            client.loadCatalog(this.catalog).asTableCatalog().alterTable(columnName, change);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchTableException err) {
            this.exitWithError("Unknown table name.");
        }
        catch (NoSuchColumnException err) {
            this.exitWithError("Unknown column name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.column + " position changed to " + this.position + ".");
    }
}

