/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.apache.gravitino.Audit;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.SupportsRoles;
import org.apache.gravitino.client.MetadataObjectPolicyOperations;
import org.apache.gravitino.client.MetadataObjectRoleOperations;
import org.apache.gravitino.client.MetadataObjectTagOperations;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.messaging.TopicDTO;
import org.apache.gravitino.exceptions.NoSuchPolicyException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.exceptions.PolicyAlreadyAssociatedException;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.SupportsPolicies;
import org.apache.gravitino.tag.SupportsTags;
import org.apache.gravitino.tag.Tag;

class GenericTopic
implements Topic,
SupportsTags,
SupportsRoles,
SupportsPolicies {
    private final TopicDTO topicDTO;
    private final MetadataObjectTagOperations objectTagOperations;
    private final MetadataObjectRoleOperations objectRoleOperations;
    private final MetadataObjectPolicyOperations objectPolicyOperations;

    GenericTopic(TopicDTO topicDTO, RESTClient restClient, Namespace topicNs) {
        this.topicDTO = topicDTO;
        ArrayList<String> topicFullName = Lists.newArrayList(topicNs.level(1), topicNs.level(2), topicDTO.name());
        MetadataObject topicObject = MetadataObjects.of(topicFullName, MetadataObject.Type.TOPIC);
        this.objectTagOperations = new MetadataObjectTagOperations(topicNs.level(0), topicObject, restClient);
        this.objectRoleOperations = new MetadataObjectRoleOperations(topicNs.level(0), topicObject, restClient);
        this.objectPolicyOperations = new MetadataObjectPolicyOperations(topicNs.level(0), topicObject, restClient);
    }

    @Override
    public Audit auditInfo() {
        return this.topicDTO.auditInfo();
    }

    @Override
    public String name() {
        return this.topicDTO.name();
    }

    @Override
    public String comment() {
        return this.topicDTO.comment();
    }

    @Override
    public Map<String, String> properties() {
        return this.topicDTO.properties();
    }

    @Override
    public SupportsTags supportsTags() {
        return this;
    }

    @Override
    public SupportsPolicies supportsPolicies() {
        return this;
    }

    @Override
    public SupportsRoles supportsRoles() {
        return this;
    }

    @Override
    public String[] listTags() {
        return this.objectTagOperations.listTags();
    }

    @Override
    public Tag[] listTagsInfo() {
        return this.objectTagOperations.listTagsInfo();
    }

    @Override
    public Tag getTag(String name) throws NoSuchTagException {
        return this.objectTagOperations.getTag(name);
    }

    @Override
    public String[] associateTags(String[] tagsToAdd, String[] tagsToRemove) {
        return this.objectTagOperations.associateTags(tagsToAdd, tagsToRemove);
    }

    @Override
    public String[] listPolicies() {
        return this.objectPolicyOperations.listPolicies();
    }

    @Override
    public Policy[] listPolicyInfos() {
        return this.objectPolicyOperations.listPolicyInfos();
    }

    @Override
    public Policy getPolicy(String name) throws NoSuchPolicyException {
        return this.objectPolicyOperations.getPolicy(name);
    }

    @Override
    public String[] associatePolicies(String[] policiesToAdd, String[] policiesToRemove) throws PolicyAlreadyAssociatedException {
        return this.objectPolicyOperations.associatePolicies(policiesToAdd, policiesToRemove);
    }

    @Override
    public String[] listBindingRoleNames() {
        return this.objectRoleOperations.listBindingRoleNames();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericTopic)) {
            return false;
        }
        GenericTopic that = (GenericTopic)obj;
        return this.topicDTO.equals(that.topicDTO);
    }

    public int hashCode() {
        return this.topicDTO.hashCode();
    }

    public String toString() {
        return "GenericTopic{topicDTO=" + this.topicDTO.toString() + "}";
    }
}

