/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.client.AuthDataProvider;
import org.apache.gravitino.client.HTTPClient;

public abstract class OAuth2TokenProvider
implements AuthDataProvider {
    protected HTTPClient client;

    @Override
    public boolean hasTokenData() {
        return true;
    }

    @Override
    public byte[] getTokenData() {
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            return null;
        }
        return ("Bearer " + accessToken).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    protected abstract String getAccessToken();

    public static abstract class OAuth2TokenProviderBuilder<SELF extends Builder<SELF, T>, T extends OAuth2TokenProvider>
    implements Builder<SELF, T> {
        private String uri;
        protected HTTPClient client;

        @Override
        public SELF withUri(String uri) {
            this.uri = uri;
            return this.self();
        }

        @Override
        public T build() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.uri), "OAuth2TokenProvider must set url");
            this.client = HTTPClient.builder(Collections.emptyMap()).uri(this.uri).build();
            T t2 = this.internalBuild();
            return t2;
        }

        private SELF self() {
            return (SELF)this;
        }

        protected abstract T internalBuild();
    }

    static interface Builder<SELF extends Builder<SELF, T>, T extends OAuth2TokenProvider> {
        public SELF withUri(String var1);

        public T build();
    }
}

