/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.client.BaseSchemaCatalog;
import org.apache.gravitino.client.DTOConverters;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.client.RelationalTable;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.CatalogDTO;
import org.apache.gravitino.dto.requests.TableCreateRequest;
import org.apache.gravitino.dto.requests.TableUpdateRequest;
import org.apache.gravitino.dto.requests.TableUpdatesRequest;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.TableResponse;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableCatalog;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.rest.RESTUtils;

class RelationalCatalog
extends BaseSchemaCatalog
implements TableCatalog {
    RelationalCatalog(Namespace namespace, String name, Catalog.Type type, String provider, String comment, Map<String, String> properties, AuditDTO auditDTO, RESTClient restClient) {
        super(namespace, name, type, provider, comment, properties, auditDTO, restClient);
    }

    @Override
    public TableCatalog asTableCatalog() {
        return this;
    }

    @Override
    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        RelationalCatalog.checkTableNamespace(namespace);
        Namespace fullNamespace = this.getTableFullNamespace(namespace);
        EntityListResponse resp = this.restClient.get(RelationalCatalog.formatTableRequestPath(fullNamespace), EntityListResponse.class, Collections.emptyMap(), ErrorHandlers.tableErrorHandler());
        resp.validate();
        return (NameIdentifier[])Arrays.stream(resp.identifiers()).map(ident -> NameIdentifier.of(ident.namespace().level(2), ident.name())).toArray(NameIdentifier[]::new);
    }

    @Override
    public Table loadTable(NameIdentifier ident) throws NoSuchTableException {
        RelationalCatalog.checkTableNameIdentifier(ident);
        Namespace fullNamespace = this.getTableFullNamespace(ident.namespace());
        TableResponse resp = this.restClient.get(RelationalCatalog.formatTableRequestPath(fullNamespace) + "/" + RESTUtils.encodeString(ident.name()), TableResponse.class, Collections.emptyMap(), ErrorHandlers.tableErrorHandler());
        resp.validate();
        return RelationalTable.from(fullNamespace, resp.getTable(), this.restClient);
    }

    @Override
    public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitioning, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        RelationalCatalog.checkTableNameIdentifier(ident);
        TableCreateRequest req = new TableCreateRequest(ident.name(), comment, org.apache.gravitino.dto.util.DTOConverters.toDTOs(columns), properties, org.apache.gravitino.dto.util.DTOConverters.toDTOs(sortOrders), org.apache.gravitino.dto.util.DTOConverters.toDTO(distribution), org.apache.gravitino.dto.util.DTOConverters.toDTOs(partitioning), org.apache.gravitino.dto.util.DTOConverters.toDTOs(indexes));
        req.validate();
        Namespace fullNamespace = this.getTableFullNamespace(ident.namespace());
        TableResponse resp = this.restClient.post(RelationalCatalog.formatTableRequestPath(fullNamespace), (RESTRequest)req, TableResponse.class, Collections.emptyMap(), ErrorHandlers.tableErrorHandler());
        resp.validate();
        return RelationalTable.from(fullNamespace, resp.getTable(), this.restClient);
    }

    @Override
    public Table alterTable(NameIdentifier ident, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        RelationalCatalog.checkTableNameIdentifier(ident);
        List<TableUpdateRequest> reqs = Arrays.stream(changes).map(DTOConverters::toTableUpdateRequest).collect(Collectors.toList());
        TableUpdatesRequest updatesRequest = new TableUpdatesRequest(reqs);
        updatesRequest.validate();
        Namespace fullNamespace = this.getTableFullNamespace(ident.namespace());
        TableResponse resp = this.restClient.put(RelationalCatalog.formatTableRequestPath(fullNamespace) + "/" + RESTUtils.encodeString(ident.name()), (RESTRequest)updatesRequest, TableResponse.class, Collections.emptyMap(), ErrorHandlers.tableErrorHandler());
        resp.validate();
        return RelationalTable.from(fullNamespace, resp.getTable(), this.restClient);
    }

    @Override
    public boolean dropTable(NameIdentifier ident) {
        RelationalCatalog.checkTableNameIdentifier(ident);
        Namespace fullNamespace = this.getTableFullNamespace(ident.namespace());
        DropResponse resp = this.restClient.delete(RelationalCatalog.formatTableRequestPath(fullNamespace) + "/" + RESTUtils.encodeString(ident.name()), DropResponse.class, Collections.emptyMap(), ErrorHandlers.tableErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    @Override
    public boolean purgeTable(NameIdentifier ident) throws UnsupportedOperationException {
        RelationalCatalog.checkTableNameIdentifier(ident);
        Namespace fullNamespace = this.getTableFullNamespace(ident.namespace());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("purge", "true");
        DropResponse resp = this.restClient.delete(RelationalCatalog.formatTableRequestPath(fullNamespace) + "/" + RESTUtils.encodeString(ident.name()), params, DropResponse.class, Collections.emptyMap(), ErrorHandlers.tableErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    @VisibleForTesting
    static String formatTableRequestPath(Namespace ns) {
        Namespace schemaNs = Namespace.of(ns.level(0), ns.level(1));
        return RelationalCatalog.formatSchemaRequestPath(schemaNs) + "/" + RESTUtils.encodeString(ns.level(2)) + "/tables";
    }

    static void checkTableNamespace(Namespace namespace) {
        Namespace.check(namespace != null && namespace.length() == 1, "Table namespace must be non-null and have 1 level, the input namespace is %s", namespace);
    }

    static void checkTableNameIdentifier(NameIdentifier ident) {
        NameIdentifier.check(ident != null, "NameIdentifier must not be null", new Object[0]);
        NameIdentifier.check(ident.name() != null && !ident.name().isEmpty(), "NameIdentifier name must not be empty", new Object[0]);
        RelationalCatalog.checkTableNamespace(ident.namespace());
    }

    private Namespace getTableFullNamespace(Namespace tableNamespace) {
        return Namespace.of(this.catalogNamespace().level(0), this.name(), tableNamespace.level(0));
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder
    extends CatalogDTO.Builder<Builder> {
        private RESTClient restClient;
        private Namespace namespace;

        protected Builder() {
        }

        Builder withNamespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        Builder withRestClient(RESTClient restClient) {
            this.restClient = restClient;
            return this;
        }

        @Override
        public RelationalCatalog build() {
            Namespace.check(this.namespace != null && this.namespace.length() == 1, "Catalog namespace must be non-null and have 1 level, the input namespace is %s", this.namespace);
            Preconditions.checkArgument(this.restClient != null, "restClient must be set");
            Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "name must not be blank");
            Preconditions.checkArgument(this.type != null, "type must not be null");
            Preconditions.checkArgument(StringUtils.isNotBlank(this.provider), "provider must not be blank");
            Preconditions.checkArgument(this.audit != null, "audit must not be null");
            return new RelationalCatalog(this.namespace, this.name, this.type, this.provider, this.comment, this.properties, this.audit, this.restClient);
        }
    }
}

