/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.credential.Credential;

public class OSSSecretKeyCredential
implements Credential {
    public static final String OSS_SECRET_KEY_CREDENTIAL_TYPE = "oss-secret-key";
    public static final String GRAVITINO_OSS_STATIC_ACCESS_KEY_ID = "oss-access-key-id";
    public static final String GRAVITINO_OSS_STATIC_SECRET_ACCESS_KEY = "oss-secret-access-key";
    private String accessKeyId;
    private String secretAccessKey;

    public OSSSecretKeyCredential(String accessKeyId, String secretAccessKey) {
        this.validate(accessKeyId, secretAccessKey, 0L);
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
    }

    public OSSSecretKeyCredential() {
    }

    @Override
    public String credentialType() {
        return OSS_SECRET_KEY_CREDENTIAL_TYPE;
    }

    @Override
    public long expireTimeInMs() {
        return 0L;
    }

    @Override
    public Map<String, String> credentialInfo() {
        return new ImmutableMap.Builder<String, String>().put(GRAVITINO_OSS_STATIC_ACCESS_KEY_ID, this.accessKeyId).put(GRAVITINO_OSS_STATIC_SECRET_ACCESS_KEY, this.secretAccessKey).build();
    }

    @Override
    public void initialize(Map<String, String> credentialInfo, long expireTimeInMs) {
        String accessKeyId = credentialInfo.get(GRAVITINO_OSS_STATIC_ACCESS_KEY_ID);
        String secretAccessKey = credentialInfo.get(GRAVITINO_OSS_STATIC_SECRET_ACCESS_KEY);
        this.validate(accessKeyId, secretAccessKey, expireTimeInMs);
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    private void validate(String accessKeyId, String secretAccessKey, long expireTimeInMs) {
        Preconditions.checkArgument(StringUtils.isNotBlank(accessKeyId), "OSS access key Id should not empty");
        Preconditions.checkArgument(StringUtils.isNotBlank(secretAccessKey), "OSS secret access key should not empty");
        Preconditions.checkArgument(expireTimeInMs == 0L, "The expire time of OSSSecretKeyCredential is not 0");
    }
}

