/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.job;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.job.JobHandle;

public class JobDTO {
    @JsonProperty(value="jobId")
    private final String jobId;
    @JsonProperty(value="jobTemplateName")
    private final String jobTemplateName;
    @JsonProperty(value="status")
    @JsonSerialize(using=StatusSerializer.class)
    @JsonDeserialize(using=StatusDeserializer.class)
    private final JobHandle.Status status;
    @JsonProperty(value="audit")
    private final AuditDTO audit;

    private JobDTO() {
        this(null, null, null, null);
    }

    public JobDTO(String jobId, String jobTemplateName, JobHandle.Status status, AuditDTO audit) {
        this.jobId = jobId;
        this.jobTemplateName = jobTemplateName;
        this.status = status;
        this.audit = audit;
    }

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(this.jobId), "\"jobId\" is required and cannot be empty");
        Preconditions.checkArgument(StringUtils.isNotBlank(this.jobTemplateName), "\"jobTemplateName\" is required and cannot be empty");
        Preconditions.checkArgument(this.status != null, "\"status\" must not be null");
        Preconditions.checkArgument(this.audit != null, "\"audit\" must not be null");
    }

    public String jobId() {
        return this.jobId;
    }

    public String jobTemplateName() {
        return this.jobTemplateName;
    }

    public JobHandle.Status status() {
        return this.status;
    }

    public AuditDTO audit() {
        return this.audit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobDTO)) {
            return false;
        }
        JobDTO other = (JobDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jobId = this.jobId();
        String other$jobId = other.jobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        String this$jobTemplateName = this.jobTemplateName();
        String other$jobTemplateName = other.jobTemplateName();
        if (this$jobTemplateName == null ? other$jobTemplateName != null : !this$jobTemplateName.equals(other$jobTemplateName)) {
            return false;
        }
        JobHandle.Status this$status = this.status();
        JobHandle.Status other$status = other.status();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        AuditDTO this$audit = this.audit();
        AuditDTO other$audit = other.audit();
        return !(this$audit == null ? other$audit != null : !((Object)this$audit).equals(other$audit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jobId = this.jobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        String $jobTemplateName = this.jobTemplateName();
        result = result * 59 + ($jobTemplateName == null ? 43 : $jobTemplateName.hashCode());
        JobHandle.Status $status = this.status();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        AuditDTO $audit = this.audit();
        result = result * 59 + ($audit == null ? 43 : ((Object)$audit).hashCode());
        return result;
    }

    public String toString() {
        return "JobDTO(jobId=" + this.jobId() + ", jobTemplateName=" + this.jobTemplateName() + ", status=" + String.valueOf((Object)this.status()) + ", audit=" + String.valueOf(this.audit()) + ")";
    }

    public static class StatusSerializer
    extends JsonSerializer<JobHandle.Status> {
        @Override
        public void serialize(JobHandle.Status value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            Preconditions.checkArgument(value != null, "\"status\" cannot be null");
            gen.writeString(value.name().toLowerCase());
        }
    }

    public static class StatusDeserializer
    extends JsonDeserializer<JobHandle.Status> {
        @Override
        public JobHandle.Status deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String value = p.getText();
            if (value != null) {
                try {
                    return JobHandle.Status.valueOf(value.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw ctxt.weirdStringException(value, JobHandle.Status.class, "Invalid status value");
                }
            }
            throw ctxt.weirdStringException(null, JobHandle.Status.class, "status cannot be null or empty");
        }
    }
}

