/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.gravitino.dto.stats.PartitionStatisticsUpdateDTO;
import org.apache.gravitino.rest.RESTRequest;

public class PartitionStatisticsUpdateRequest
implements RESTRequest {
    @JsonProperty(value="updates")
    private final List<PartitionStatisticsUpdateDTO> updates;

    public PartitionStatisticsUpdateRequest(List<PartitionStatisticsUpdateDTO> updates) {
        this.updates = updates;
    }

    public PartitionStatisticsUpdateRequest() {
        this(null);
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(this.updates != null && !this.updates.isEmpty(), "\"updates\" must not be null or empty.");
        for (PartitionStatisticsUpdateDTO update : this.updates) {
            update.validate();
        }
    }

    public List<PartitionStatisticsUpdateDTO> getUpdates() {
        return this.updates;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartitionStatisticsUpdateRequest)) {
            return false;
        }
        PartitionStatisticsUpdateRequest other = (PartitionStatisticsUpdateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PartitionStatisticsUpdateDTO> this$updates = this.getUpdates();
        List<PartitionStatisticsUpdateDTO> other$updates = other.getUpdates();
        return !(this$updates == null ? other$updates != null : !((Object)this$updates).equals(other$updates));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartitionStatisticsUpdateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PartitionStatisticsUpdateDTO> $updates = this.getUpdates();
        result = result * 59 + ($updates == null ? 43 : ((Object)$updates).hashCode());
        return result;
    }

    public String toString() {
        return "PartitionStatisticsUpdateRequest(updates=" + String.valueOf(this.getUpdates()) + ")";
    }
}

