/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Privileges;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.SecurableObjects;
import org.apache.gravitino.dto.rel.DistributionDTO;
import org.apache.gravitino.dto.rel.SortOrderDTO;
import org.apache.gravitino.dto.rel.expressions.FunctionArg;
import org.apache.gravitino.dto.rel.indexes.IndexDTO;
import org.apache.gravitino.dto.rel.partitioning.Partitioning;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.BaseMetalake;
import org.apache.gravitino.meta.CatalogEntity;
import org.apache.gravitino.meta.ColumnEntity;
import org.apache.gravitino.meta.FilesetEntity;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.ModelEntity;
import org.apache.gravitino.meta.ModelVersionEntity;
import org.apache.gravitino.meta.PolicyEntity;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.meta.SchemaEntity;
import org.apache.gravitino.meta.SchemaVersion;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.meta.TagEntity;
import org.apache.gravitino.meta.TopicEntity;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.PolicyContent;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.storage.relational.po.CatalogPO;
import org.apache.gravitino.storage.relational.po.ColumnPO;
import org.apache.gravitino.storage.relational.po.ExtendedGroupPO;
import org.apache.gravitino.storage.relational.po.ExtendedUserPO;
import org.apache.gravitino.storage.relational.po.FilesetPO;
import org.apache.gravitino.storage.relational.po.FilesetVersionPO;
import org.apache.gravitino.storage.relational.po.GroupPO;
import org.apache.gravitino.storage.relational.po.GroupRoleRelPO;
import org.apache.gravitino.storage.relational.po.MetalakePO;
import org.apache.gravitino.storage.relational.po.ModelPO;
import org.apache.gravitino.storage.relational.po.ModelVersionAliasRelPO;
import org.apache.gravitino.storage.relational.po.ModelVersionPO;
import org.apache.gravitino.storage.relational.po.OwnerRelPO;
import org.apache.gravitino.storage.relational.po.PolicyMetadataObjectRelPO;
import org.apache.gravitino.storage.relational.po.PolicyPO;
import org.apache.gravitino.storage.relational.po.PolicyVersionPO;
import org.apache.gravitino.storage.relational.po.RolePO;
import org.apache.gravitino.storage.relational.po.SchemaPO;
import org.apache.gravitino.storage.relational.po.SecurableObjectPO;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.gravitino.storage.relational.po.TagMetadataObjectRelPO;
import org.apache.gravitino.storage.relational.po.TagPO;
import org.apache.gravitino.storage.relational.po.TopicPO;
import org.apache.gravitino.storage.relational.po.UserPO;
import org.apache.gravitino.storage.relational.po.UserRoleRelPO;
import org.apache.gravitino.utils.PrincipalUtils;

public class POConverters {
    public static final long INIT_VERSION = 1L;
    public static final long DEFAULT_DELETED_AT = 0L;

    private POConverters() {
    }

    public static MetalakePO initializeMetalakePOWithVersion(BaseMetalake baseMetalake) {
        try {
            return MetalakePO.builder().withMetalakeId(baseMetalake.id()).withMetalakeName(baseMetalake.name()).withMetalakeComment(baseMetalake.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(baseMetalake.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)baseMetalake.auditInfo())).withSchemaVersion(JsonUtils.anyFieldMapper().writeValueAsString((Object)baseMetalake.getVersion())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static MetalakePO updateMetalakePOWithVersion(MetalakePO oldMetalakePO, BaseMetalake newMetalake) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldMetalakePO.getLastVersion();
        try {
            return MetalakePO.builder().withMetalakeId(newMetalake.id()).withMetalakeName(newMetalake.name()).withMetalakeComment(newMetalake.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(newMetalake.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newMetalake.auditInfo())).withSchemaVersion(JsonUtils.anyFieldMapper().writeValueAsString((Object)newMetalake.getVersion())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static BaseMetalake fromMetalakePO(MetalakePO metalakePO) {
        try {
            return BaseMetalake.builder().withId(metalakePO.getMetalakeId()).withName(metalakePO.getMetalakeName()).withComment(metalakePO.getMetalakeComment()).withProperties((Map)JsonUtils.anyFieldMapper().readValue(metalakePO.getProperties(), Map.class)).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(metalakePO.getAuditInfo(), AuditInfo.class)).withVersion((SchemaVersion)((Object)JsonUtils.anyFieldMapper().readValue(metalakePO.getSchemaVersion(), SchemaVersion.class))).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static List<BaseMetalake> fromMetalakePOs(List<MetalakePO> metalakePOs) {
        return metalakePOs.stream().map(POConverters::fromMetalakePO).collect(Collectors.toList());
    }

    public static CatalogPO initializeCatalogPOWithVersion(CatalogEntity catalogEntity, Long metalakeId) {
        try {
            return CatalogPO.builder().withCatalogId(catalogEntity.id()).withCatalogName(catalogEntity.name()).withMetalakeId(metalakeId).withType(catalogEntity.getType().name()).withProvider(catalogEntity.getProvider()).withCatalogComment(catalogEntity.getComment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(catalogEntity.getProperties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)catalogEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static CatalogPO updateCatalogPOWithVersion(CatalogPO oldCatalogPO, CatalogEntity newCatalog, Long metalakeId) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldCatalogPO.getLastVersion();
        try {
            return CatalogPO.builder().withCatalogId(newCatalog.id()).withCatalogName(newCatalog.name()).withMetalakeId(metalakeId).withType(newCatalog.getType().name()).withProvider(newCatalog.getProvider()).withCatalogComment(newCatalog.getComment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(newCatalog.getProperties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newCatalog.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static CatalogEntity fromCatalogPO(CatalogPO catalogPO, Namespace namespace) {
        try {
            return CatalogEntity.builder().withId(catalogPO.getCatalogId()).withName(catalogPO.getCatalogName()).withNamespace(namespace).withType(Catalog.Type.valueOf((String)catalogPO.getType())).withProvider(catalogPO.getProvider()).withComment(catalogPO.getCatalogComment()).withProperties((Map)JsonUtils.anyFieldMapper().readValue(catalogPO.getProperties(), Map.class)).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(catalogPO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static List<CatalogEntity> fromCatalogPOs(List<CatalogPO> catalogPOs, Namespace namespace) {
        return catalogPOs.stream().map(catalogPO -> POConverters.fromCatalogPO(catalogPO, namespace)).collect(Collectors.toList());
    }

    public static SchemaPO initializeSchemaPOWithVersion(SchemaEntity schemaEntity, SchemaPO.Builder builder) {
        try {
            return builder.withSchemaId(schemaEntity.id()).withSchemaName(schemaEntity.name()).withSchemaComment(schemaEntity.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(schemaEntity.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)schemaEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static SchemaPO updateSchemaPOWithVersion(SchemaPO oldSchemaPO, SchemaEntity newSchema) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldSchemaPO.getLastVersion();
        try {
            return SchemaPO.builder().withSchemaId(oldSchemaPO.getSchemaId()).withSchemaName(newSchema.name()).withMetalakeId(oldSchemaPO.getMetalakeId()).withCatalogId(oldSchemaPO.getCatalogId()).withSchemaComment(newSchema.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(newSchema.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newSchema.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static SchemaEntity fromSchemaPO(SchemaPO schemaPO, Namespace namespace) {
        try {
            return SchemaEntity.builder().withId(schemaPO.getSchemaId()).withName(schemaPO.getSchemaName()).withNamespace(namespace).withComment(schemaPO.getSchemaComment()).withProperties((Map)JsonUtils.anyFieldMapper().readValue(schemaPO.getProperties(), Map.class)).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(schemaPO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static List<SchemaEntity> fromSchemaPOs(List<SchemaPO> schemaPOs, Namespace namespace) {
        return schemaPOs.stream().map(schemaPO -> POConverters.fromSchemaPO(schemaPO, namespace)).collect(Collectors.toList());
    }

    public static TablePO initializeTablePOWithVersion(TableEntity tableEntity, TablePO.Builder builder) {
        try {
            builder.withTableId(tableEntity.id()).withTableName(tableEntity.name()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)tableEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).withFormat(tableEntity.properties() == null ? null : (String)tableEntity.properties().getOrDefault("format", null)).withComment(tableEntity.comment()).withProperties(tableEntity.properties() == null ? null : JsonUtils.anyFieldMapper().writeValueAsString(tableEntity.properties())).withIndexes(tableEntity.indexes() == null ? null : JsonUtils.anyFieldMapper().writeValueAsString((Object)DTOConverters.toDTOs((Index[])tableEntity.indexes()))).withDistribution(tableEntity.distribution() == null ? null : JsonUtils.anyFieldMapper().writeValueAsString((Object)DTOConverters.toDTO((Distribution)tableEntity.distribution()))).withSortOrders(tableEntity.sortOrders() == null ? null : JsonUtils.anyFieldMapper().writeValueAsString((Object)DTOConverters.toDTOs((SortOrder[])tableEntity.sortOrders()))).withPartitions(tableEntity.partitioning() == null ? null : JsonUtils.anyFieldMapper().writeValueAsString((Object)DTOConverters.toDTOs((Transform[])tableEntity.partitioning())));
            return builder.build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static TablePO updateTablePOWithVersionAndSchemaId(TablePO oldTablePO, TableEntity newTable, Long newSchemaId) {
        Long lastVersion;
        Long currentVersion = lastVersion = Long.valueOf(oldTablePO.getLastVersion() + 1L);
        try {
            TablePO.Builder builder = TablePO.builder().withTableId(oldTablePO.getTableId()).withTableName(newTable.name()).withMetalakeId(oldTablePO.getMetalakeId()).withCatalogId(oldTablePO.getCatalogId()).withSchemaId(newSchemaId).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newTable.auditInfo())).withCurrentVersion(currentVersion).withLastVersion(lastVersion).withDeletedAt(0L).withComment(newTable.comment()).withProperties(newTable.properties() == null ? null : JsonUtils.anyFieldMapper().writeValueAsString(newTable.properties())).withIndexes(newTable.indexes() == null ? null : JsonUtils.anyFieldMapper().writeValueAsString((Object)DTOConverters.toDTOs((Index[])newTable.indexes()))).withDistribution(newTable.distribution() == null ? null : JsonUtils.anyFieldMapper().writeValueAsString((Object)DTOConverters.toDTO((Distribution)newTable.distribution()))).withSortOrders(newTable.sortOrders() == null ? null : JsonUtils.anyFieldMapper().writeValueAsString((Object)DTOConverters.toDTOs((SortOrder[])newTable.sortOrders()))).withPartitions(newTable.partitioning() == null ? null : JsonUtils.anyFieldMapper().writeValueAsString((Object)DTOConverters.toDTOs((Transform[])newTable.partitioning()))).withFormat(newTable.properties() == null ? null : (String)newTable.properties().getOrDefault("format", null));
            return builder.build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static TableEntity fromTablePO(TablePO tablePO, Namespace namespace) {
        return POConverters.fromTableAndColumnPOs(tablePO, Collections.emptyList(), namespace);
    }

    public static TableEntity fromTableAndColumnPOs(TablePO tablePO, List<ColumnPO> columnPOs, Namespace namespace) {
        try {
            HashMap properties;
            Map map = properties = StringUtils.isBlank((CharSequence)tablePO.getProperties()) ? Maps.newHashMap() : (Map)JsonUtils.anyFieldMapper().readValue(tablePO.getProperties(), Map.class);
            if (StringUtils.isNotBlank((CharSequence)tablePO.getFormat())) {
                properties.put("format", tablePO.getFormat());
            }
            return TableEntity.builder().withId(tablePO.getTableId()).withName(tablePO.getTableName()).withNamespace(namespace).withColumns(POConverters.fromColumnPOs(columnPOs)).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(tablePO.getAuditInfo(), AuditInfo.class)).withDistribution(StringUtils.isBlank((CharSequence)tablePO.getDistribution()) ? null : DTOConverters.fromDTO((DistributionDTO)((DistributionDTO)JsonUtils.anyFieldMapper().readValue(tablePO.getDistribution(), DistributionDTO.class)))).withSortOrders(StringUtils.isBlank((CharSequence)tablePO.getSortOrders()) ? null : DTOConverters.fromDTOs((SortOrderDTO[])((SortOrderDTO[])JsonUtils.anyFieldMapper().readValue(tablePO.getSortOrders(), SortOrderDTO[].class)))).withIndexes(StringUtils.isBlank((CharSequence)tablePO.getIndexes()) ? null : DTOConverters.fromDTOs((IndexDTO[])((IndexDTO[])JsonUtils.anyFieldMapper().readValue(tablePO.getIndexes(), IndexDTO[].class)))).withPartitioning(StringUtils.isBlank((CharSequence)tablePO.getPartitions()) ? null : (Transform[])JsonUtils.anyFieldMapper().readValue(tablePO.getPartitions(), Partitioning[].class)).withComment(tablePO.getComment()).withProperties(properties).withColumns(POConverters.fromColumnPOs(columnPOs)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static ColumnEntity fromColumnPO(ColumnPO columnPO) {
        try {
            return ColumnEntity.builder().withId(columnPO.getColumnId()).withName(columnPO.getColumnName()).withPosition(columnPO.getColumnPosition()).withDataType((Type)JsonUtils.anyFieldMapper().readValue(columnPO.getColumnType(), Type.class)).withComment(columnPO.getColumnComment()).withAutoIncrement(ColumnPO.AutoIncrement.fromValue(columnPO.getAutoIncrement()).autoIncrement()).withNullable(ColumnPO.Nullable.fromValue(columnPO.getNullable()).nullable()).withDefaultValue(columnPO.getDefaultValue() == null ? Column.DEFAULT_VALUE_NOT_SET : DTOConverters.fromFunctionArg((FunctionArg)((FunctionArg)JsonUtils.anyFieldMapper().readValue(columnPO.getDefaultValue(), Expression.class)))).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(columnPO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static List<ColumnEntity> fromColumnPOs(List<ColumnPO> columnPOs) {
        return columnPOs.stream().map(POConverters::fromColumnPO).collect(Collectors.toList());
    }

    public static ColumnPO initializeColumnPO(TablePO tablePO, ColumnEntity columnEntity, ColumnPO.ColumnOpType opType) {
        try {
            return ColumnPO.builder().withColumnId(columnEntity.id()).withColumnName(columnEntity.name()).withColumnPosition(columnEntity.position()).withMetalakeId(tablePO.getMetalakeId()).withCatalogId(tablePO.getCatalogId()).withSchemaId(tablePO.getSchemaId()).withTableId(tablePO.getTableId()).withTableVersion(tablePO.getCurrentVersion()).withColumnType(JsonUtils.anyFieldMapper().writeValueAsString((Object)columnEntity.dataType())).withColumnComment(columnEntity.comment()).withNullable(ColumnPO.Nullable.fromBoolean(columnEntity.nullable()).value()).withAutoIncrement(ColumnPO.AutoIncrement.fromBoolean(columnEntity.autoIncrement()).value()).withDefaultValue(columnEntity.defaultValue() == null || columnEntity.defaultValue().equals(Column.DEFAULT_VALUE_NOT_SET) ? null : JsonUtils.anyFieldMapper().writeValueAsString((Object)DTOConverters.toFunctionArg((Expression)columnEntity.defaultValue()))).withColumnOpType(opType.value()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)columnEntity.auditInfo())).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static List<ColumnPO> initializeColumnPOs(TablePO tablePO, List<ColumnEntity> columnEntities, ColumnPO.ColumnOpType opType) {
        return columnEntities.stream().map(columnEntity -> POConverters.initializeColumnPO(tablePO, columnEntity, opType)).collect(Collectors.toList());
    }

    public static List<TableEntity> fromTablePOs(List<TablePO> tablePOs, Namespace namespace) {
        return tablePOs.stream().map(tablePO -> POConverters.fromTablePO(tablePO, namespace)).collect(Collectors.toList());
    }

    public static FilesetPO initializeFilesetPOWithVersion(FilesetEntity filesetEntity, FilesetPO.Builder builder) {
        try {
            String props = JsonUtils.anyFieldMapper().writeValueAsString(filesetEntity.properties());
            List<FilesetVersionPO> filesetVersionPOs = filesetEntity.storageLocations().entrySet().stream().map(entry -> FilesetVersionPO.builder().withMetalakeId(builder.getFilesetMetalakeId()).withCatalogId(builder.getFilesetCatalogId()).withSchemaId(builder.getFilesetSchemaId()).withFilesetId(filesetEntity.id()).withVersion(1L).withFilesetComment(filesetEntity.comment()).withLocationName((String)entry.getKey()).withStorageLocation((String)entry.getValue()).withProperties(props).withDeletedAt(0L).build()).collect(Collectors.toList());
            return builder.withFilesetId(filesetEntity.id()).withFilesetName(filesetEntity.name()).withType(filesetEntity.filesetType().name()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)filesetEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).withFilesetVersionPOs(filesetVersionPOs).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static FilesetPO updateFilesetPOWithVersion(FilesetPO oldFilesetPO, FilesetEntity newFileset, boolean needUpdateVersion) {
        try {
            List<FilesetVersionPO> newFilesetVersionPOs;
            Long currentVersion;
            Long lastVersion = oldFilesetPO.getLastVersion();
            if (needUpdateVersion) {
                Long l = lastVersion;
                lastVersion = lastVersion + 1L;
                currentVersion = lastVersion;
                String props = JsonUtils.anyFieldMapper().writeValueAsString(newFileset.properties());
                newFilesetVersionPOs = newFileset.storageLocations().entrySet().stream().map(entry -> FilesetVersionPO.builder().withMetalakeId(oldFilesetPO.getMetalakeId()).withCatalogId(oldFilesetPO.getCatalogId()).withSchemaId(oldFilesetPO.getSchemaId()).withFilesetId(newFileset.id()).withVersion(currentVersion).withFilesetComment(newFileset.comment()).withLocationName((String)entry.getKey()).withStorageLocation((String)entry.getValue()).withProperties(props).withDeletedAt(0L).build()).collect(Collectors.toList());
            } else {
                currentVersion = oldFilesetPO.getCurrentVersion();
                newFilesetVersionPOs = oldFilesetPO.getFilesetVersionPOs();
            }
            return FilesetPO.builder().withFilesetId(newFileset.id()).withFilesetName(newFileset.name()).withMetalakeId(oldFilesetPO.getMetalakeId()).withCatalogId(oldFilesetPO.getCatalogId()).withSchemaId(oldFilesetPO.getSchemaId()).withType(newFileset.filesetType().name()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newFileset.auditInfo())).withCurrentVersion(currentVersion).withLastVersion(lastVersion).withDeletedAt(0L).withFilesetVersionPOs(newFilesetVersionPOs).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static boolean checkFilesetVersionNeedUpdate(List<FilesetVersionPO> oldFilesetVersionPOs, FilesetEntity newFileset) {
        Map<String, String> storageLocations = oldFilesetVersionPOs.stream().collect(Collectors.toMap(FilesetVersionPO::getLocationName, FilesetVersionPO::getStorageLocation));
        if (!StringUtils.equals((CharSequence)oldFilesetVersionPOs.get(0).getFilesetComment(), (CharSequence)newFileset.comment()) || !Objects.equals(storageLocations, newFileset.storageLocations())) {
            return true;
        }
        try {
            Map oldProperties = (Map)JsonUtils.anyFieldMapper().readValue(oldFilesetVersionPOs.get(0).getProperties(), Map.class);
            if (oldProperties == null) {
                return newFileset.properties() != null;
            }
            return !oldProperties.equals(newFileset.properties());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static boolean checkPolicyVersionNeedUpdate(PolicyVersionPO oldPolicyVersionPO, PolicyEntity newPolicy) {
        if (!StringUtils.equals((CharSequence)oldPolicyVersionPO.getPolicyComment(), (CharSequence)newPolicy.comment()) || oldPolicyVersionPO.isEnabled() != newPolicy.enabled()) {
            return true;
        }
        try {
            PolicyContent oldContent = (PolicyContent)JsonUtils.anyFieldMapper().readValue(oldPolicyVersionPO.getContent(), newPolicy.policyType().contentClass());
            if (oldContent == null) {
                return newPolicy.content() != null;
            }
            return !oldContent.equals(newPolicy.content());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static PolicyPO updatePolicyPOWithVersion(PolicyPO oldPolicyPO, PolicyEntity newPolicy, boolean needUpdateVersion) {
        try {
            PolicyVersionPO newPolicyVersionPO;
            Long currentVersion;
            Long lastVersion = oldPolicyPO.getLastVersion();
            if (needUpdateVersion) {
                Long l = lastVersion;
                lastVersion = lastVersion + 1L;
                currentVersion = lastVersion;
                newPolicyVersionPO = PolicyVersionPO.builder().withMetalakeId(oldPolicyPO.getMetalakeId()).withPolicyId(newPolicy.id()).withVersion(currentVersion).withPolicyComment(newPolicy.comment()).withEnabled(newPolicy.enabled()).withContent(JsonUtils.anyFieldMapper().writeValueAsString((Object)newPolicy.content())).withDeletedAt(0L).build();
            } else {
                currentVersion = oldPolicyPO.getCurrentVersion();
                newPolicyVersionPO = oldPolicyPO.getPolicyVersionPO();
            }
            return PolicyPO.builder().withPolicyId(newPolicy.id()).withPolicyName(newPolicy.name()).withPolicyType(newPolicy.policyType().name()).withMetalakeId(oldPolicyPO.getMetalakeId()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newPolicy.auditInfo())).withCurrentVersion(currentVersion).withLastVersion(lastVersion).withDeletedAt(0L).withPolicyVersionPO(newPolicyVersionPO).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static FilesetEntity fromFilesetPO(FilesetPO filesetPO, Namespace namespace) {
        Map<String, String> storageLocations = filesetPO.getFilesetVersionPOs().stream().collect(Collectors.toMap(FilesetVersionPO::getLocationName, FilesetVersionPO::getStorageLocation));
        try {
            return FilesetEntity.builder().withId(filesetPO.getFilesetId()).withName(filesetPO.getFilesetName()).withNamespace(namespace).withComment(filesetPO.getFilesetVersionPOs().get(0).getFilesetComment()).withFilesetType(Fileset.Type.valueOf((String)filesetPO.getType())).withStorageLocations(storageLocations).withProperties((Map)JsonUtils.anyFieldMapper().readValue(filesetPO.getFilesetVersionPOs().get(0).getProperties(), Map.class)).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(filesetPO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static TopicEntity fromTopicPO(TopicPO topicPO, Namespace namespace) {
        try {
            return TopicEntity.builder().withId(topicPO.getTopicId()).withName(topicPO.getTopicName()).withNamespace(namespace).withComment(topicPO.getComment()).withProperties((Map)JsonUtils.anyFieldMapper().readValue(topicPO.getProperties(), Map.class)).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(topicPO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static List<FilesetEntity> fromFilesetPOs(List<FilesetPO> filesetPOs, Namespace namespace) {
        return filesetPOs.stream().map(filesetPO -> POConverters.fromFilesetPO(filesetPO, namespace)).collect(Collectors.toList());
    }

    public static List<TopicEntity> fromTopicPOs(List<TopicPO> topicPOs, Namespace namespace) {
        return topicPOs.stream().map(topicPO -> POConverters.fromTopicPO(topicPO, namespace)).collect(Collectors.toList());
    }

    public static TopicPO initializeTopicPOWithVersion(TopicEntity topicEntity, TopicPO.Builder builder) {
        try {
            return builder.withTopicId(topicEntity.id()).withTopicName(topicEntity.name()).withComment(topicEntity.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(topicEntity.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)topicEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static TopicPO updateTopicPOWithVersion(TopicPO oldTopicPO, TopicEntity newEntity) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldTopicPO.getLastVersion();
        try {
            return TopicPO.builder().withTopicId(oldTopicPO.getTopicId()).withTopicName(newEntity.name()).withMetalakeId(oldTopicPO.getMetalakeId()).withCatalogId(oldTopicPO.getCatalogId()).withSchemaId(oldTopicPO.getSchemaId()).withComment(newEntity.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(newEntity.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newEntity.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static UserPO initializeUserPOWithVersion(UserEntity userEntity, UserPO.Builder builder) {
        try {
            return builder.withUserId(userEntity.id()).withUserName(userEntity.name()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)userEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static UserPO updateUserPOWithVersion(UserPO oldUserPO, UserEntity newUser) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldUserPO.getLastVersion();
        try {
            return UserPO.builder().withUserId(oldUserPO.getUserId()).withUserName(newUser.name()).withMetalakeId(oldUserPO.getMetalakeId()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newUser.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static UserEntity fromUserPO(UserPO userPO, List<RolePO> rolePOs, Namespace namespace) {
        try {
            List<String> roleNames = rolePOs.stream().map(RolePO::getRoleName).collect(Collectors.toList());
            List<Long> roleIds = rolePOs.stream().map(RolePO::getRoleId).collect(Collectors.toList());
            UserEntity.Builder builder = UserEntity.builder().withId(userPO.getUserId()).withName(userPO.getUserName()).withNamespace(namespace).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(userPO.getAuditInfo(), AuditInfo.class));
            if (!roleNames.isEmpty()) {
                builder.withRoleNames(roleNames);
            }
            if (!roleIds.isEmpty()) {
                builder.withRoleIds(roleIds);
            }
            return builder.build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static UserEntity fromExtendedUserPO(ExtendedUserPO userPO, Namespace namespace) {
        try {
            List roleIdsFromJson;
            List<Long> roleIds;
            List roleNamesFromJson;
            List<String> roleNames;
            UserEntity.Builder builder = UserEntity.builder().withId(userPO.getUserId()).withName(userPO.getUserName()).withNamespace(namespace).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(userPO.getAuditInfo(), AuditInfo.class));
            if (StringUtils.isNotBlank((CharSequence)userPO.getRoleNames()) && !(roleNames = (roleNamesFromJson = (List)JsonUtils.anyFieldMapper().readValue(userPO.getRoleNames(), List.class)).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList())).isEmpty()) {
                builder.withRoleNames(roleNames);
            }
            if (StringUtils.isNotBlank((CharSequence)userPO.getRoleIds()) && !(roleIds = (roleIdsFromJson = (List)JsonUtils.anyFieldMapper().readValue(userPO.getRoleIds(), List.class)).stream().filter(Objects::nonNull).map(String::valueOf).filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList())).isEmpty()) {
                builder.withRoleIds(roleIds);
            }
            return builder.build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static GroupEntity fromGroupPO(GroupPO groupPO, List<RolePO> rolePOs, Namespace namespace) {
        try {
            List<String> roleNames = rolePOs.stream().map(RolePO::getRoleName).collect(Collectors.toList());
            List<Long> roleIds = rolePOs.stream().map(RolePO::getRoleId).collect(Collectors.toList());
            GroupEntity.Builder builder = GroupEntity.builder().withId(groupPO.getGroupId()).withName(groupPO.getGroupName()).withNamespace(namespace).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(groupPO.getAuditInfo(), AuditInfo.class));
            if (!roleNames.isEmpty()) {
                builder.withRoleNames(roleNames);
            }
            if (!roleIds.isEmpty()) {
                builder.withRoleIds(roleIds);
            }
            return builder.build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static GroupEntity fromExtendedGroupPO(ExtendedGroupPO groupPO, Namespace namespace) {
        try {
            List roleIdsFromJson;
            List<Long> roleIds;
            List roleNamesFromJson;
            List<String> roleNames;
            GroupEntity.Builder builder = GroupEntity.builder().withId(groupPO.getGroupId()).withName(groupPO.getGroupName()).withNamespace(namespace).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(groupPO.getAuditInfo(), AuditInfo.class));
            if (StringUtils.isNotBlank((CharSequence)groupPO.getRoleNames()) && !(roleNames = (roleNamesFromJson = (List)JsonUtils.anyFieldMapper().readValue(groupPO.getRoleNames(), List.class)).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList())).isEmpty()) {
                builder.withRoleNames(roleNames);
            }
            if (StringUtils.isNotBlank((CharSequence)groupPO.getRoleIds()) && !(roleIds = (roleIdsFromJson = (List)JsonUtils.anyFieldMapper().readValue(groupPO.getRoleIds(), List.class)).stream().filter(Objects::nonNull).map(String::valueOf).filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList())).isEmpty()) {
                builder.withRoleIds(roleIds);
            }
            return builder.build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static List<UserRoleRelPO> initializeUserRoleRelsPOWithVersion(UserEntity userEntity, List<Long> roleIds) {
        try {
            ArrayList userRoleRelPOs = Lists.newArrayList();
            for (Long roleId : roleIds) {
                UserRoleRelPO roleRelPO = UserRoleRelPO.builder().withUserId(userEntity.id()).withRoleId(roleId).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)userEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
                userRoleRelPOs.add(roleRelPO);
            }
            return userRoleRelPOs;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static RolePO initializeRolePOWithVersion(RoleEntity roleEntity, RolePO.Builder builder) {
        try {
            return builder.withRoleId(roleEntity.id()).withRoleName(roleEntity.name()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(roleEntity.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)roleEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static GroupPO initializeGroupPOWithVersion(GroupEntity groupEntity, GroupPO.Builder builder) {
        try {
            return builder.withGroupId(groupEntity.id()).withGroupName(groupEntity.name()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)groupEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static GroupPO updateGroupPOWithVersion(GroupPO oldGroupPO, GroupEntity newGroup) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldGroupPO.getLastVersion();
        try {
            return GroupPO.builder().withGroupId(oldGroupPO.getGroupId()).withGroupName(newGroup.name()).withMetalakeId(oldGroupPO.getMetalakeId()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newGroup.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static List<GroupRoleRelPO> initializeGroupRoleRelsPOWithVersion(GroupEntity groupEntity, List<Long> roleIds) {
        try {
            ArrayList groupRoleRelPOS = Lists.newArrayList();
            for (Long roleId : roleIds) {
                GroupRoleRelPO roleRelPO = GroupRoleRelPO.builder().withGroupId(groupEntity.id()).withRoleId(roleId).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)groupEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
                groupRoleRelPOS.add(roleRelPO);
            }
            return groupRoleRelPOS;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static SecurableObject fromSecurableObjectPO(String fullName, SecurableObjectPO securableObjectPO, MetadataObject.Type type) {
        try {
            List privilegeNames = (List)JsonUtils.anyFieldMapper().readValue(securableObjectPO.getPrivilegeNames(), List.class);
            List privilegeConditions = (List)JsonUtils.anyFieldMapper().readValue(securableObjectPO.getPrivilegeConditions(), List.class);
            ArrayList privileges = Lists.newArrayList();
            for (int index = 0; index < privilegeNames.size(); ++index) {
                if (Privilege.Condition.ALLOW.name().equals(privilegeConditions.get(index))) {
                    privileges.add(Privileges.allow((String)((String)privilegeNames.get(index))));
                    continue;
                }
                privileges.add(Privileges.deny((String)((String)privilegeNames.get(index))));
            }
            return SecurableObjects.parse((String)fullName, (MetadataObject.Type)type, (List)privileges);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static RoleEntity fromRolePO(RolePO rolePO, List<SecurableObject> securableObjects, Namespace namespace) {
        try {
            return RoleEntity.builder().withId(rolePO.getRoleId()).withName(rolePO.getRoleName()).withNamespace(namespace).withProperties((Map)JsonUtils.anyFieldMapper().readValue(rolePO.getProperties(), Map.class)).withSecurableObjects(securableObjects).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(rolePO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static SecurableObjectPO.Builder initializeSecurablePOBuilderWithVersion(long roleId, SecurableObject securableObject, String type) {
        try {
            SecurableObjectPO.Builder builder = SecurableObjectPO.builder();
            builder.withRoleId(roleId).withType(type).withPrivilegeConditions(JsonUtils.anyFieldMapper().writeValueAsString(securableObject.privileges().stream().map(Privilege::condition).map(Enum::name).collect(Collectors.toList()))).withPrivilegeNames(JsonUtils.anyFieldMapper().writeValueAsString(securableObject.privileges().stream().map(Privilege::name).map(Enum::name).collect(Collectors.toList()))).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L);
            return builder;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static RolePO updateRolePOWithVersion(RolePO oldRolePO, RoleEntity newRole) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldRolePO.getLastVersion();
        try {
            return RolePO.builder().withRoleId(oldRolePO.getRoleId()).withRoleName(newRole.name()).withMetalakeId(oldRolePO.getMetalakeId()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(newRole.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newRole.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static TagEntity fromTagPO(TagPO tagPO, Namespace namespace) {
        try {
            return TagEntity.builder().withId(tagPO.getTagId()).withName(tagPO.getTagName()).withNamespace(namespace).withComment(tagPO.getComment()).withProperties((Map)JsonUtils.anyFieldMapper().readValue(tagPO.getProperties(), Map.class)).withAuditInfo((Audit)JsonUtils.anyFieldMapper().readValue(tagPO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static TagPO initializeTagPOWithVersion(TagEntity tagEntity, TagPO.Builder builder) {
        try {
            return builder.withTagId(tagEntity.id()).withTagName(tagEntity.name()).withComment(tagEntity.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(tagEntity.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)tagEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static TagPO updateTagPOWithVersion(TagPO oldTagPO, TagEntity newEntity) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldTagPO.getLastVersion();
        try {
            return TagPO.builder().withTagId(oldTagPO.getTagId()).withTagName(newEntity.name()).withMetalakeId(oldTagPO.getMetalakeId()).withComment(newEntity.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(newEntity.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newEntity.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static TagMetadataObjectRelPO initializeTagMetadataObjectRelPOWithVersion(Long tagId, Long metadataObjectId, String metadataObjectType) {
        try {
            AuditInfo auditInfo = AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build();
            return TagMetadataObjectRelPO.builder().withTagId(tagId).withMetadataObjectId(metadataObjectId).withMetadataObjectType(metadataObjectType).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)auditInfo)).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static PolicyEntity fromPolicyPO(PolicyPO policyPO, Namespace namespace) {
        try {
            Policy.BuiltInType policyType = Policy.BuiltInType.fromPolicyType((String)policyPO.getPolicyType());
            return PolicyEntity.builder().withId(policyPO.getPolicyId()).withName(policyPO.getPolicyName()).withNamespace(namespace).withPolicyType(policyType).withComment(policyPO.getPolicyVersionPO().getPolicyComment()).withEnabled(policyPO.getPolicyVersionPO().isEnabled()).withContent((PolicyContent)JsonUtils.anyFieldMapper().readValue(policyPO.getPolicyVersionPO().getContent(), policyType.contentClass())).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(policyPO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static PolicyPO initializePolicyPOWithVersion(PolicyEntity policyEntity, PolicyPO.Builder builder) {
        try {
            String content = JsonUtils.anyFieldMapper().writeValueAsString((Object)policyEntity.content());
            PolicyVersionPO policyVersionPO = PolicyVersionPO.builder().withMetalakeId(builder.getMetalakeId()).withPolicyId(policyEntity.id()).withVersion(1L).withPolicyComment(policyEntity.comment()).withEnabled(policyEntity.enabled()).withContent(content).withDeletedAt(0L).build();
            return builder.withPolicyId(policyEntity.id()).withPolicyName(policyEntity.name()).withPolicyType(policyEntity.policyType().name()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)policyEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).withPolicyVersionPO(policyVersionPO).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static PolicyMetadataObjectRelPO initializePolicyMetadataObjectRelPOWithVersion(Long policyId, Long metadataObjectId, String metadataObjectType) {
        try {
            AuditInfo auditInfo = AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build();
            return PolicyMetadataObjectRelPO.builder().withPolicyId(policyId).withMetadataObjectId(metadataObjectId).withMetadataObjectType(metadataObjectType).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)auditInfo)).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static OwnerRelPO initializeOwnerRelPOsWithVersion(Long metalakeId, String ownerType, Long ownerId, String metadataObjectType, Long metadataObjectId) {
        try {
            AuditInfo auditInfo = AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build();
            return OwnerRelPO.builder().withMetalakeId(metalakeId).withOwnerId(ownerId).withOwnerType(ownerType).withMetadataObjectId(metadataObjectId).withMetadataObjectType(metadataObjectType).withAuditIfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)auditInfo)).withCurrentVersion(1L).withLastVersion(1L).withDeleteAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static ModelEntity fromModelPO(ModelPO modelPO, Namespace namespace) {
        try {
            return ModelEntity.builder().withId(modelPO.getModelId()).withName(modelPO.getModelName()).withNamespace(namespace).withComment(modelPO.getModelComment()).withLatestVersion(modelPO.getModelLatestVersion()).withProperties((Map)JsonUtils.anyFieldMapper().readValue(modelPO.getModelProperties(), Map.class)).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(modelPO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static ModelPO initializeModelPO(ModelEntity modelEntity, ModelPO.Builder builder) {
        try {
            return builder.withModelId(modelEntity.id()).withModelName(modelEntity.name()).withModelComment(modelEntity.comment()).withModelLatestVersion(modelEntity.latestVersion()).withModelProperties(JsonUtils.anyFieldMapper().writeValueAsString(modelEntity.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)modelEntity.auditInfo())).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static ModelVersionEntity fromModelVersionPO(NameIdentifier modelIdent, List<ModelVersionPO> modelVersionPOs, List<ModelVersionAliasRelPO> aliasRelPOs) {
        List<String> aliases = aliasRelPOs.stream().map(ModelVersionAliasRelPO::getModelVersionAlias).collect(Collectors.toList());
        Map<String, String> uris = modelVersionPOs.stream().collect(Collectors.toMap(ModelVersionPO::getModelVersionUriName, ModelVersionPO::getModelVersionUri));
        ModelVersionPO modelVersionPO = modelVersionPOs.get(0);
        try {
            return ModelVersionEntity.builder().withModelIdentifier(modelIdent).withVersion(modelVersionPO.getModelVersion()).withAliases(aliases).withComment(modelVersionPO.getModelVersionComment()).withUris(uris).withProperties((Map)JsonUtils.anyFieldMapper().readValue(modelVersionPO.getModelVersionProperties(), Map.class)).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(modelVersionPO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static ModelPO updateModelPO(ModelPO oldModelPO, ModelEntity newModel) {
        try {
            return ModelPO.builder().withModelId(newModel.id()).withModelName(newModel.name()).withMetalakeId(oldModelPO.getMetalakeId()).withCatalogId(oldModelPO.getCatalogId()).withSchemaId(oldModelPO.getSchemaId()).withModelComment(newModel.comment()).withModelLatestVersion(newModel.latestVersion()).withModelProperties(JsonUtils.anyFieldMapper().writeValueAsString(newModel.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newModel.auditInfo())).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static ModelVersionPO updateModelVersionPO(ModelVersionPO oldModelVersionPO, ModelVersionEntity newModelVersion) {
        try {
            return ModelVersionPO.builder().withModelId(oldModelVersionPO.getModelId()).withMetalakeId(oldModelVersionPO.getMetalakeId()).withCatalogId(oldModelVersionPO.getCatalogId()).withSchemaId(oldModelVersionPO.getSchemaId()).withModelVersionUriName(oldModelVersionPO.getModelVersionUriName()).withModelVersionUri(oldModelVersionPO.getModelVersionUri()).withModelVersion(oldModelVersionPO.getModelVersion()).withModelVersionComment(newModelVersion.comment()).withModelVersionProperties(JsonUtils.anyFieldMapper().writeValueAsString(newModelVersion.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newModelVersion.auditInfo())).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static List<ModelVersionAliasRelPO> updateModelVersionAliasRelPO(List<ModelVersionAliasRelPO> oldModelVersionAliasRelPOs, ModelVersionEntity newModelVersion) {
        if (!oldModelVersionAliasRelPOs.isEmpty()) {
            ModelVersionAliasRelPO oldModelVersionAliasRelPO = oldModelVersionAliasRelPOs.get(0);
            return newModelVersion.aliases().stream().map(alias -> POConverters.createAliasRelPO(oldModelVersionAliasRelPO, alias)).collect(Collectors.toList());
        }
        return newModelVersion.aliases().stream().map(alias -> POConverters.createAliasRelPO(newModelVersion, alias)).collect(Collectors.toList());
    }

    public static List<ModelVersionPO> initializeModelVersionPO(ModelVersionEntity modelVersionEntity, Long modelId) {
        try {
            String modelVersionProperties = JsonUtils.anyFieldMapper().writeValueAsString(modelVersionEntity.properties());
            String modelVersionAuditInfo = JsonUtils.anyFieldMapper().writeValueAsString((Object)modelVersionEntity.auditInfo());
            return modelVersionEntity.uris().entrySet().stream().map(entry -> ModelVersionPO.builder().withModelId(modelId).withModelVersion(modelVersionEntity.version()).withModelVersionComment(modelVersionEntity.comment()).withModelVersionUriName((String)entry.getKey()).withModelVersionUri((String)entry.getValue()).withModelVersionProperties(modelVersionProperties).withAuditInfo(modelVersionAuditInfo).withDeletedAt(0L).build()).collect(Collectors.toList());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static List<ModelVersionAliasRelPO> initializeModelVersionAliasRelPO(ModelVersionEntity modelVersionEntity, Long modelId) {
        return modelVersionEntity.aliases().stream().map(a -> ModelVersionAliasRelPO.builder().withModelVersion(modelVersionEntity.version()).withModelVersionAlias((String)a).withModelId(modelId).withDeletedAt(0L).build()).collect(Collectors.toList());
    }

    private static ModelVersionAliasRelPO createAliasRelPO(ModelVersionAliasRelPO oldModelVersionAliasRelPO, String alias) {
        return ModelVersionAliasRelPO.builder().withModelVersion(oldModelVersionAliasRelPO.getModelVersion()).withModelVersionAlias(alias).withModelId(oldModelVersionAliasRelPO.getModelId()).withDeletedAt(0L).build();
    }

    private static ModelVersionAliasRelPO createAliasRelPO(ModelVersionEntity entity, String alias) {
        return ModelVersionAliasRelPO.builder().withModelVersion(entity.version()).withModelVersionAlias(alias).withModelId(entity.id()).withDeletedAt(0L).build();
    }
}

