/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractCharComparator;
import it.unimi.dsi.fastutil.chars.CharComparator;

public class CharComparators {
    public static final CharComparator NATURAL_COMPARATOR = new AbstractCharComparator(){

        @Override
        public final int compare(char a, char b) {
            return a < b ? -1 : (a == b ? 0 : 1);
        }
    };
    public static final CharComparator OPPOSITE_COMPARATOR = new AbstractCharComparator(){

        @Override
        public final int compare(char a, char b) {
            return -(a < b ? -1 : (a == b ? 0 : 1));
        }
    };

    private CharComparators() {
    }

    public static CharComparator oppositeComparator(final CharComparator c) {
        return new AbstractCharComparator(){
            private final CharComparator comparator;
            {
                this.comparator = c;
            }

            @Override
            public final int compare(char a, char b) {
                return -this.comparator.compare(a, b);
            }
        };
    }
}

