/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.ProxyPlugin;
import org.apache.gravitino.connector.TableOperations;
import org.apache.gravitino.utils.PrincipalUtils;

public class OperationsProxy<T>
implements InvocationHandler {
    private final ProxyPlugin plugin;
    private final T ops;

    private OperationsProxy(ProxyPlugin plugin, T ops) {
        this.plugin = plugin;
        this.ops = ops;
    }

    public static <T> T createProxy(T ops, ProxyPlugin plugin) {
        if (!(ops instanceof CatalogOperations) && !(ops instanceof TableOperations)) {
            throw new IllegalArgumentException("Method only supports the type of CatalogOperations or TableOperations");
        }
        if (ops instanceof CatalogOperations) {
            plugin.bindCatalogOperation((CatalogOperations)ops);
        }
        return OperationsProxy.createProxyInternal(ops, plugin, ops.getClass().getInterfaces());
    }

    private static <T> T createProxyInternal(T ops, ProxyPlugin plugin, Class<?>[] interfaces) {
        return (T)Proxy.newProxyInstance(ops.getClass().getClassLoader(), interfaces, new OperationsProxy<T>(plugin, ops));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.plugin.doAs(PrincipalUtils.getCurrentPrincipal(), () -> method.invoke(this.ops, args), Collections.emptyMap());
    }
}

