/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.util;

import com.lancedb.lance.namespace.util.ValidationUtil;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PropertyUtil {
    private PropertyUtil() {
    }

    public static boolean propertyAsBoolean(Map<String, String> properties, String property, boolean defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static Boolean propertyAsNullableBoolean(Map<String, String> properties, String property) {
        String value = properties.get(property);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    public static double propertyAsDouble(Map<String, String> properties, String property, double defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return Double.parseDouble(value);
        }
        return defaultValue;
    }

    public static int propertyAsInt(Map<String, String> properties, String property, int defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public static Integer propertyAsNullableInt(Map<String, String> properties, String property) {
        String value = properties.get(property);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return null;
    }

    public static long propertyAsLong(Map<String, String> properties, String property, long defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    public static Long propertyAsNullableLong(Map<String, String> properties, String property) {
        String value = properties.get(property);
        if (value != null) {
            return Long.parseLong(value);
        }
        return null;
    }

    public static String propertyAsString(Map<String, String> properties, String property, String defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static String propertyAsString(Map<String, String> properties, String property) {
        String value = properties.get(property);
        ValidationUtil.checkNotNull(value, "Property %s must be set", property);
        return value;
    }

    public static String propertyAsNullableString(Map<String, String> properties, String property) {
        return properties.get(property);
    }

    public static Map<String, String> propertiesWithPrefix(Map<String, String> properties, String prefix) {
        if (properties == null || properties.isEmpty()) {
            return Collections.emptyMap();
        }
        ValidationUtil.checkArgument(prefix != null, "Invalid prefix: null", new Object[0]);
        return properties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).replaceFirst(prefix, ""), Map.Entry::getValue));
    }

    public static Map<String, String> filterProperties(Map<String, String> properties, Predicate<String> keyPredicate) {
        if (properties == null || properties.isEmpty()) {
            return Collections.emptyMap();
        }
        ValidationUtil.checkArgument(keyPredicate != null, "Invalid key pattern: null", new Object[0]);
        return properties.entrySet().stream().filter(e -> keyPredicate.test((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

