/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.timeline.recovery.LeveldbTimelineStateStore;
import org.apache.hadoop.yarn.server.timeline.recovery.TimelineStateStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineDelgationTokenSecretManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineV1DelegationTokenSecretManagerService
extends TimelineDelgationTokenSecretManagerService {
    private TimelineStateStore stateStore = null;

    public TimelineV1DelegationTokenSecretManagerService() {
        super(TimelineV1DelegationTokenSecretManagerService.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (conf.getBoolean("yarn.timeline-service.recovery.enabled", false)) {
            this.stateStore = this.createStateStore(conf);
            this.stateStore.init(conf);
        }
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        if (this.stateStore != null) {
            this.stateStore.start();
            TimelineStateStore.TimelineServiceState state = this.stateStore.loadState();
            ((TimelineV1DelegationTokenSecretManager)this.getTimelineDelegationTokenSecretManager()).recover(state);
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.stateStore != null) {
            this.stateStore.stop();
        }
        super.serviceStop();
    }

    protected AbstractDelegationTokenSecretManager<TimelineDelegationTokenIdentifier> createTimelineDelegationTokenSecretManager(long secretKeyInterval, long tokenMaxLifetime, long tokenRenewInterval, long tokenRemovalScanInterval) {
        return new TimelineV1DelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, tokenRemovalScanInterval, this.stateStore);
    }

    protected TimelineStateStore createStateStore(Configuration conf) {
        return (TimelineStateStore)((Object)ReflectionUtils.newInstance((Class)conf.getClass("yarn.timeline-service.state-store-class", LeveldbTimelineStateStore.class, TimelineStateStore.class), (Configuration)conf));
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class TimelineV1DelegationTokenSecretManager
    extends AbstractDelegationTokenSecretManager<TimelineDelegationTokenIdentifier> {
        public static final Logger LOG = LoggerFactory.getLogger(TimelineV1DelegationTokenSecretManager.class);
        private TimelineStateStore stateStore;

        public TimelineV1DelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, TimelineStateStore stateStore) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
            this.stateStore = stateStore;
        }

        public TimelineDelegationTokenIdentifier createIdentifier() {
            return new TimelineDelegationTokenIdentifier();
        }

        protected void storeNewMasterKey(DelegationKey key) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Storing master key " + key.getKeyId());
            }
            try {
                if (this.stateStore != null) {
                    this.stateStore.storeTokenMasterKey(key);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to store master key " + key.getKeyId(), (Throwable)e);
            }
        }

        protected void removeStoredMasterKey(DelegationKey key) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing master key " + key.getKeyId());
            }
            try {
                if (this.stateStore != null) {
                    this.stateStore.removeTokenMasterKey(key);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to remove master key " + key.getKeyId(), (Throwable)e);
            }
        }

        protected void storeNewToken(TimelineDelegationTokenIdentifier tokenId, long renewDate) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Storing token " + tokenId.getSequenceNumber());
            }
            try {
                if (this.stateStore != null) {
                    this.stateStore.storeToken(tokenId, renewDate);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to store token " + tokenId.getSequenceNumber(), (Throwable)e);
            }
        }

        protected void removeStoredToken(TimelineDelegationTokenIdentifier tokenId) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Storing token " + tokenId.getSequenceNumber());
            }
            try {
                if (this.stateStore != null) {
                    this.stateStore.removeToken(tokenId);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to remove token " + tokenId.getSequenceNumber(), (Throwable)e);
            }
        }

        protected void updateStoredToken(TimelineDelegationTokenIdentifier tokenId, long renewDate) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating token " + tokenId.getSequenceNumber());
            }
            try {
                if (this.stateStore != null) {
                    this.stateStore.updateToken(tokenId, renewDate);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to update token " + tokenId.getSequenceNumber(), (Throwable)e);
            }
        }

        public void recover(TimelineStateStore.TimelineServiceState state) throws IOException {
            LOG.info("Recovering " + ((Object)((Object)this)).getClass().getSimpleName());
            for (DelegationKey delegationKey : state.getTokenMasterKeyState()) {
                this.addKey(delegationKey);
            }
            this.delegationTokenSequenceNumber = state.getLatestSequenceNumber();
            for (Map.Entry entry : state.getTokenState().entrySet()) {
                this.addPersistedDelegationToken((AbstractDelegationTokenIdentifier)entry.getKey(), (Long)entry.getValue());
            }
        }
    }
}

