/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.JniLoader;
import java.io.Closeable;
import java.io.IOException;

public final class BlobFile
implements Closeable {
    private long nativeBlobHandle;

    public byte[] read() throws IOException {
        return this.nativeRead();
    }

    public byte[] readUpTo(int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("len must be non-negative");
        }
        return this.nativeReadUpTo(len);
    }

    public void seek(long newCursor) throws IOException {
        if (newCursor < 0L) {
            throw new IllegalArgumentException("newCursor must be non-negative");
        }
        this.nativeSeek(newCursor);
    }

    public long tell() throws IOException {
        return this.nativeTell();
    }

    public long size() {
        return this.nativeSize();
    }

    @Override
    public void close() throws IOException {
        this.nativeClose();
    }

    private native byte[] nativeRead() throws IOException;

    private native byte[] nativeReadUpTo(int var1) throws IOException;

    private native byte[] nativeReadRange(long var1, int var3) throws IOException;

    private native void nativeSeek(long var1) throws IOException;

    private native long nativeTell() throws IOException;

    private native long nativeSize();

    private native void nativeClose() throws IOException;

    static {
        JniLoader.ensureLoaded();
    }
}

