/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class Branch {
    private final String name;
    private final Optional<String> parentBranch;
    private final long parentVersion;
    private final long createAt;
    private final int manifestSize;

    public Branch(String name, String parentBranch, long parentVersion, long createAt, int manifestSize) {
        this.name = name;
        this.parentBranch = Optional.ofNullable(parentBranch);
        this.parentVersion = parentVersion;
        this.createAt = createAt;
        this.manifestSize = manifestSize;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getParentBranch() {
        return this.parentBranch;
    }

    public long getParentVersion() {
        return this.parentVersion;
    }

    public long getCreateAt() {
        return this.createAt;
    }

    public int getManifestSize() {
        return this.manifestSize;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("parentBranch", this.parentBranch).add("parentVersion", this.parentVersion).add("createAt", this.createAt).add("manifestSize", this.manifestSize).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Branch branch = (Branch)o;
        return this.parentVersion == branch.parentVersion && this.createAt == branch.createAt && this.manifestSize == branch.manifestSize && Objects.equals(this.name, branch.name) && Objects.equals(this.parentBranch, branch.parentBranch);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parentBranch, this.parentVersion, this.createAt, this.manifestSize);
    }
}

