/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.file;

import com.lancedb.lance.JniLoader;
import com.lancedb.lance.WriteParams;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.Data;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.DictionaryProvider;

public class LanceFileWriter
implements AutoCloseable {
    private long nativeFileWriterHandle;
    private BufferAllocator allocator;
    private DictionaryProvider dictionaryProvider;

    private static native LanceFileWriter openNative(String var0, Optional<String> var1, Map<String, String> var2) throws IOException;

    private native void closeNative(long var1) throws IOException;

    private native void writeNative(long var1, long var3) throws IOException;

    private LanceFileWriter() {
    }

    public static LanceFileWriter open(String path, BufferAllocator allocator, DictionaryProvider dictionaryProvider) throws IOException {
        return LanceFileWriter.open(path, allocator, dictionaryProvider, Collections.emptyMap());
    }

    public static LanceFileWriter open(String path, BufferAllocator allocator, DictionaryProvider dictionaryProvider, Map<String, String> storageOptions) throws IOException {
        return LanceFileWriter.open(path, allocator, dictionaryProvider, Optional.empty(), storageOptions);
    }

    public static LanceFileWriter open(String path, BufferAllocator allocator, DictionaryProvider dictionaryProvider, Optional<WriteParams.LanceFileVersion> dataStorageVersion, Map<String, String> storageOptions) throws IOException {
        Optional<String> dataStorageVersionStr = dataStorageVersion.map(WriteParams.LanceFileVersion::getVersionString);
        LanceFileWriter writer = LanceFileWriter.openNative(path, dataStorageVersionStr, storageOptions);
        writer.allocator = allocator;
        writer.dictionaryProvider = dictionaryProvider;
        return writer;
    }

    public void write(VectorSchemaRoot batch) throws IOException {
        try (ArrowArray ffiArrowArray = ArrowArray.allocateNew((BufferAllocator)this.allocator);
             ArrowSchema ffiArrowSchema = ArrowSchema.allocateNew((BufferAllocator)this.allocator);){
            Data.exportVectorSchemaRoot((BufferAllocator)this.allocator, (VectorSchemaRoot)batch, (DictionaryProvider)this.dictionaryProvider, (ArrowArray)ffiArrowArray, (ArrowSchema)ffiArrowSchema);
            this.writeNative(ffiArrowArray.memoryAddress(), ffiArrowSchema.memoryAddress());
        }
    }

    @Override
    public void close() throws Exception {
        this.closeNative(this.nativeFileWriterHandle);
    }

    static {
        JniLoader.ensureLoaded();
    }
}

