/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.operation;

import com.lancedb.lance.index.Index;
import com.lancedb.lance.operation.Operation;
import com.lancedb.lance.operation.RewriteGroup;
import com.lancedb.lance.operation.RewrittenIndex;
import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Rewrite
implements Operation {
    private final List<RewriteGroup> groups;
    private final List<RewrittenIndex> rewrittenIndices;
    private final Optional<Index> fragReuseIndex;

    private Rewrite(List<RewriteGroup> groups, List<RewrittenIndex> rewrittenIndices, Index fragReuseIndex) {
        this.groups = groups != null ? groups : new ArrayList();
        this.rewrittenIndices = rewrittenIndices != null ? rewrittenIndices : new ArrayList();
        this.fragReuseIndex = Optional.ofNullable(fragReuseIndex);
    }

    @Override
    public String name() {
        return "Rewrite";
    }

    public List<RewriteGroup> groups() {
        return this.groups;
    }

    public List<RewrittenIndex> rewrittenIndices() {
        return this.rewrittenIndices;
    }

    public Optional<Index> fragReuseIndex() {
        return this.fragReuseIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rewrite rewrite = (Rewrite)o;
        return Objects.equals(this.groups, rewrite.groups) && Objects.equals(this.rewrittenIndices, rewrite.rewrittenIndices) && Objects.equals(this.fragReuseIndex, rewrite.fragReuseIndex);
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.rewrittenIndices, this.fragReuseIndex);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("groups", this.groups).add("rewrittenIndices", this.rewrittenIndices).add("fragReuseIndex", this.fragReuseIndex).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<RewriteGroup> groups;
        private List<RewrittenIndex> rewrittenIndices;
        private Index fragReuseIndex;

        private Builder() {
        }

        public Builder groups(List<RewriteGroup> groups) {
            this.groups = groups;
            return this;
        }

        public Builder rewrittenIndices(List<RewrittenIndex> rewrittenIndices) {
            this.rewrittenIndices = rewrittenIndices;
            return this;
        }

        public Builder fragReuseIndex(Index fragReuseIndex) {
            this.fragReuseIndex = fragReuseIndex;
            return this;
        }

        public Rewrite build() {
            return new Rewrite(this.groups, this.rewrittenIndices, this.fragReuseIndex);
        }
    }
}

