/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.shaded.guava.graph;

import com.lancedb.lance.shaded.guava.annotations.Beta;
import com.lancedb.lance.shaded.guava.base.Preconditions;
import com.lancedb.lance.shaded.guava.collect.ImmutableSet;
import com.lancedb.lance.shaded.guava.collect.Iterables;
import com.lancedb.lance.shaded.guava.collect.Iterators;
import com.lancedb.lance.shaded.guava.collect.Maps;
import com.lancedb.lance.shaded.guava.errorprone.annotations.CanIgnoreReturnValue;
import com.lancedb.lance.shaded.guava.graph.ElementTypesAreNonnullByDefault;
import com.lancedb.lance.shaded.guava.graph.EndpointPair;
import com.lancedb.lance.shaded.guava.graph.ForwardingGraph;
import com.lancedb.lance.shaded.guava.graph.ForwardingNetwork;
import com.lancedb.lance.shaded.guava.graph.ForwardingValueGraph;
import com.lancedb.lance.shaded.guava.graph.Graph;
import com.lancedb.lance.shaded.guava.graph.GraphBuilder;
import com.lancedb.lance.shaded.guava.graph.GraphsBridgeMethods;
import com.lancedb.lance.shaded.guava.graph.ImmutableGraph;
import com.lancedb.lance.shaded.guava.graph.IncidentEdgeSet;
import com.lancedb.lance.shaded.guava.graph.MutableGraph;
import com.lancedb.lance.shaded.guava.graph.MutableNetwork;
import com.lancedb.lance.shaded.guava.graph.MutableValueGraph;
import com.lancedb.lance.shaded.guava.graph.Network;
import com.lancedb.lance.shaded.guava.graph.NetworkBuilder;
import com.lancedb.lance.shaded.guava.graph.Traverser;
import com.lancedb.lance.shaded.guava.graph.ValueGraph;
import com.lancedb.lance.shaded.guava.graph.ValueGraphBuilder;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@Beta
public final class Graphs
extends GraphsBridgeMethods {
    private Graphs() {
    }

    public static <N> boolean hasCycle(Graph<N> graph) {
        int numEdges = graph.edges().size();
        if (numEdges == 0) {
            return false;
        }
        if (!graph.isDirected() && numEdges >= graph.nodes().size()) {
            return true;
        }
        HashMap<Object, NodeVisitState> visitedNodes = Maps.newHashMapWithExpectedSize(graph.nodes().size());
        for (N node : graph.nodes()) {
            if (!Graphs.subgraphHasCycle(graph, visitedNodes, node)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCycle(Network<?, ?> network) {
        if (!network.isDirected() && network.allowsParallelEdges() && network.edges().size() > network.asGraph().edges().size()) {
            return true;
        }
        return Graphs.hasCycle(network.asGraph());
    }

    private static <N> boolean subgraphHasCycle(Graph<N> graph, Map<Object, NodeVisitState> visitedNodes, N startNode) {
        ArrayDeque stack = new ArrayDeque();
        stack.addLast(new NodeAndRemainingSuccessors<N>(startNode));
        while (!stack.isEmpty()) {
            Object nextNode;
            Object previousNode;
            NodeAndRemainingSuccessors top = (NodeAndRemainingSuccessors)stack.removeLast();
            NodeAndRemainingSuccessors prev = (NodeAndRemainingSuccessors)stack.peekLast();
            stack.addLast(top);
            Object node = top.node;
            Object v0 = previousNode = prev == null ? null : prev.node;
            if (top.remainingSuccessors == null) {
                NodeVisitState state = visitedNodes.get(node);
                if (state == NodeVisitState.COMPLETE) {
                    stack.removeLast();
                    continue;
                }
                if (state == NodeVisitState.PENDING) {
                    return true;
                }
                visitedNodes.put(node, NodeVisitState.PENDING);
                top.remainingSuccessors = new ArrayDeque(graph.successors(node));
            }
            if (!top.remainingSuccessors.isEmpty() && Graphs.canTraverseWithoutReusingEdge(graph, nextNode = top.remainingSuccessors.remove(), previousNode)) {
                stack.addLast(new NodeAndRemainingSuccessors(nextNode));
                continue;
            }
            stack.removeLast();
            visitedNodes.put(node, NodeVisitState.COMPLETE);
        }
        return false;
    }

    private static boolean canTraverseWithoutReusingEdge(Graph<?> graph, Object nextNode, @CheckForNull Object previousNode) {
        return graph.isDirected() || !com.lancedb.lance.shaded.guava.base.Objects.equal(previousNode, nextNode);
    }

    public static <N> ImmutableGraph<N> transitiveClosure(Graph<N> graph) {
        ImmutableGraph.Builder transitiveClosure = GraphBuilder.from(graph).allowsSelfLoops(true).immutable();
        if (graph.isDirected()) {
            for (N node : graph.nodes()) {
                for (Object reachableNode : Graphs.reachableNodes(graph, node)) {
                    transitiveClosure.putEdge(node, reachableNode);
                }
            }
        } else {
            HashSet visitedNodes = new HashSet();
            for (N node : graph.nodes()) {
                if (visitedNodes.contains(node)) continue;
                ImmutableSet reachableNodes = Graphs.reachableNodes(graph, node);
                visitedNodes.addAll(reachableNodes);
                int pairwiseMatch = 1;
                for (Object nodeU : reachableNodes) {
                    for (Object nodeV : Iterables.limit(reachableNodes, pairwiseMatch++)) {
                        transitiveClosure.putEdge(nodeU, nodeV);
                    }
                }
            }
        }
        return transitiveClosure.build();
    }

    public static <N> ImmutableSet<N> reachableNodes(Graph<N> graph, N node) {
        Preconditions.checkArgument(graph.nodes().contains(node), "Node %s is not an element of this graph.", node);
        return ImmutableSet.copyOf(Traverser.forGraph(graph).breadthFirst(node));
    }

    public static <N> Graph<N> transpose(Graph<N> graph) {
        if (!graph.isDirected()) {
            return graph;
        }
        if (graph instanceof TransposedGraph) {
            return ((TransposedGraph)graph).graph;
        }
        return new TransposedGraph<N>(graph);
    }

    public static <N, V> ValueGraph<N, V> transpose(ValueGraph<N, V> graph) {
        if (!graph.isDirected()) {
            return graph;
        }
        if (graph instanceof TransposedValueGraph) {
            return ((TransposedValueGraph)graph).graph;
        }
        return new TransposedValueGraph<N, V>(graph);
    }

    public static <N, E> Network<N, E> transpose(Network<N, E> network) {
        if (!network.isDirected()) {
            return network;
        }
        if (network instanceof TransposedNetwork) {
            return ((TransposedNetwork)network).network;
        }
        return new TransposedNetwork<N, E>(network);
    }

    static <N> EndpointPair<N> transpose(EndpointPair<N> endpoints) {
        if (endpoints.isOrdered()) {
            return EndpointPair.ordered(endpoints.target(), endpoints.source());
        }
        return endpoints;
    }

    public static <N> MutableGraph<N> inducedSubgraph(Graph<N> graph, Iterable<? extends N> nodes) {
        MutableGraph subgraph = nodes instanceof Collection ? GraphBuilder.from(graph).expectedNodeCount(((Collection)nodes).size()).build() : GraphBuilder.from(graph).build();
        for (Object node : nodes) {
            subgraph.addNode(node);
        }
        for (Object node : subgraph.nodes()) {
            for (Object successorNode : graph.successors(node)) {
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.putEdge(node, successorNode);
            }
        }
        return subgraph;
    }

    public static <N, V> MutableValueGraph<N, V> inducedSubgraph(ValueGraph<N, V> graph, Iterable<? extends N> nodes) {
        MutableValueGraph subgraph = nodes instanceof Collection ? ValueGraphBuilder.from(graph).expectedNodeCount(((Collection)nodes).size()).build() : ValueGraphBuilder.from(graph).build();
        for (Object node : nodes) {
            subgraph.addNode(node);
        }
        for (Object node : subgraph.nodes()) {
            for (Object successorNode : graph.successors(node)) {
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.putEdgeValue(node, successorNode, Objects.requireNonNull(graph.edgeValueOrDefault(node, successorNode, null)));
            }
        }
        return subgraph;
    }

    public static <N, E> MutableNetwork<N, E> inducedSubgraph(Network<N, E> network, Iterable<? extends N> nodes) {
        MutableNetwork subgraph = nodes instanceof Collection ? NetworkBuilder.from(network).expectedNodeCount(((Collection)nodes).size()).build() : NetworkBuilder.from(network).build();
        for (Object node : nodes) {
            subgraph.addNode(node);
        }
        for (Object node : subgraph.nodes()) {
            for (E edge : network.outEdges(node)) {
                N successorNode = network.incidentNodes(edge).adjacentNode(node);
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.addEdge(node, successorNode, edge);
            }
        }
        return subgraph;
    }

    public static <N> MutableGraph<N> copyOf(Graph<N> graph) {
        MutableGraph copy = GraphBuilder.from(graph).expectedNodeCount(graph.nodes().size()).build();
        for (N n : graph.nodes()) {
            copy.addNode(n);
        }
        for (EndpointPair endpointPair : graph.edges()) {
            copy.putEdge(endpointPair.nodeU(), endpointPair.nodeV());
        }
        return copy;
    }

    public static <N, V> MutableValueGraph<N, V> copyOf(ValueGraph<N, V> graph) {
        MutableValueGraph copy = ValueGraphBuilder.from(graph).expectedNodeCount(graph.nodes().size()).build();
        for (Object n : graph.nodes()) {
            copy.addNode(n);
        }
        for (EndpointPair endpointPair : graph.edges()) {
            copy.putEdgeValue(endpointPair.nodeU(), endpointPair.nodeV(), Objects.requireNonNull(graph.edgeValueOrDefault(endpointPair.nodeU(), endpointPair.nodeV(), null)));
        }
        return copy;
    }

    public static <N, E> MutableNetwork<N, E> copyOf(Network<N, E> network) {
        MutableNetwork copy = NetworkBuilder.from(network).expectedNodeCount(network.nodes().size()).expectedEdgeCount(network.edges().size()).build();
        for (N node : network.nodes()) {
            copy.addNode(node);
        }
        for (Object edge : network.edges()) {
            EndpointPair<N> endpointPair = network.incidentNodes(edge);
            copy.addEdge(endpointPair.nodeU(), endpointPair.nodeV(), edge);
        }
        return copy;
    }

    @CanIgnoreReturnValue
    static int checkNonNegative(int value) {
        Preconditions.checkArgument(value >= 0, "Not true that %s is non-negative.", value);
        return value;
    }

    @CanIgnoreReturnValue
    static long checkNonNegative(long value) {
        Preconditions.checkArgument(value >= 0L, "Not true that %s is non-negative.", value);
        return value;
    }

    @CanIgnoreReturnValue
    static int checkPositive(int value) {
        Preconditions.checkArgument(value > 0, "Not true that %s is positive.", value);
        return value;
    }

    @CanIgnoreReturnValue
    static long checkPositive(long value) {
        Preconditions.checkArgument(value > 0L, "Not true that %s is positive.", value);
        return value;
    }

    private static final class NodeAndRemainingSuccessors<N> {
        final N node;
        @CheckForNull
        Queue<N> remainingSuccessors;

        NodeAndRemainingSuccessors(N node) {
            this.node = node;
        }
    }

    private static enum NodeVisitState {
        PENDING,
        COMPLETE;

    }

    private static class TransposedGraph<N>
    extends ForwardingGraph<N> {
        private final Graph<N> graph;

        TransposedGraph(Graph<N> graph) {
            this.graph = graph;
        }

        @Override
        Graph<N> delegate() {
            return this.graph;
        }

        @Override
        public Set<N> predecessors(N node) {
            return this.delegate().successors((Object)node);
        }

        @Override
        public Set<N> successors(N node) {
            return this.delegate().predecessors((Object)node);
        }

        @Override
        public Set<EndpointPair<N>> incidentEdges(N node) {
            return new IncidentEdgeSet<N>(this, node){

                @Override
                public Iterator<EndpointPair<N>> iterator() {
                    return Iterators.transform(this.delegate().incidentEdges(this.node).iterator(), edge -> EndpointPair.of(this.delegate(), edge.nodeV(), edge.nodeU()));
                }
            };
        }

        @Override
        public int inDegree(N node) {
            return this.delegate().outDegree(node);
        }

        @Override
        public int outDegree(N node) {
            return this.delegate().inDegree(node);
        }

        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            return this.delegate().hasEdgeConnecting(nodeV, nodeU);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpoints));
        }
    }

    private static class TransposedValueGraph<N, V>
    extends ForwardingValueGraph<N, V> {
        private final ValueGraph<N, V> graph;

        TransposedValueGraph(ValueGraph<N, V> graph) {
            this.graph = graph;
        }

        @Override
        ValueGraph<N, V> delegate() {
            return this.graph;
        }

        @Override
        public Set<N> predecessors(N node) {
            return this.delegate().successors((Object)node);
        }

        @Override
        public Set<N> successors(N node) {
            return this.delegate().predecessors((Object)node);
        }

        @Override
        public int inDegree(N node) {
            return this.delegate().outDegree(node);
        }

        @Override
        public int outDegree(N node) {
            return this.delegate().inDegree(node);
        }

        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            return this.delegate().hasEdgeConnecting(nodeV, nodeU);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpoints));
        }

        @Override
        public Optional<V> edgeValue(N nodeU, N nodeV) {
            return this.delegate().edgeValue(nodeV, nodeU);
        }

        @Override
        public Optional<V> edgeValue(EndpointPair<N> endpoints) {
            return this.delegate().edgeValue(Graphs.transpose(endpoints));
        }

        @Override
        @CheckForNull
        public V edgeValueOrDefault(N nodeU, N nodeV, @CheckForNull V defaultValue) {
            return this.delegate().edgeValueOrDefault(nodeV, nodeU, defaultValue);
        }

        @Override
        @CheckForNull
        public V edgeValueOrDefault(EndpointPair<N> endpoints, @CheckForNull V defaultValue) {
            return this.delegate().edgeValueOrDefault(Graphs.transpose(endpoints), defaultValue);
        }
    }

    private static class TransposedNetwork<N, E>
    extends ForwardingNetwork<N, E> {
        private final Network<N, E> network;

        TransposedNetwork(Network<N, E> network) {
            this.network = network;
        }

        @Override
        Network<N, E> delegate() {
            return this.network;
        }

        @Override
        public Set<N> predecessors(N node) {
            return this.delegate().successors((Object)node);
        }

        @Override
        public Set<N> successors(N node) {
            return this.delegate().predecessors((Object)node);
        }

        @Override
        public int inDegree(N node) {
            return this.delegate().outDegree(node);
        }

        @Override
        public int outDegree(N node) {
            return this.delegate().inDegree(node);
        }

        @Override
        public Set<E> inEdges(N node) {
            return this.delegate().outEdges(node);
        }

        @Override
        public Set<E> outEdges(N node) {
            return this.delegate().inEdges(node);
        }

        @Override
        public EndpointPair<N> incidentNodes(E edge) {
            EndpointPair<N> endpointPair = this.delegate().incidentNodes(edge);
            return EndpointPair.of(this.network, endpointPair.nodeV(), endpointPair.nodeU());
        }

        @Override
        public Set<E> edgesConnecting(N nodeU, N nodeV) {
            return this.delegate().edgesConnecting(nodeV, nodeU);
        }

        @Override
        public Set<E> edgesConnecting(EndpointPair<N> endpoints) {
            return this.delegate().edgesConnecting(Graphs.transpose(endpoints));
        }

        @Override
        public Optional<E> edgeConnecting(N nodeU, N nodeV) {
            return this.delegate().edgeConnecting(nodeV, nodeU);
        }

        @Override
        public Optional<E> edgeConnecting(EndpointPair<N> endpoints) {
            return this.delegate().edgeConnecting(Graphs.transpose(endpoints));
        }

        @Override
        @CheckForNull
        public E edgeConnectingOrNull(N nodeU, N nodeV) {
            return this.delegate().edgeConnectingOrNull(nodeV, nodeU);
        }

        @Override
        @CheckForNull
        public E edgeConnectingOrNull(EndpointPair<N> endpoints) {
            return this.delegate().edgeConnectingOrNull(Graphs.transpose(endpoints));
        }

        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            return this.delegate().hasEdgeConnecting(nodeV, nodeU);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpoints));
        }
    }
}

