/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.dataset.namespace.resolver;

import io.openlineage.client.dataset.namespace.resolver.DatasetNamespaceResolver;
import io.openlineage.client.dataset.namespace.resolver.HostListNamespaceResolverConfig;
import org.apache.commons.lang3.StringUtils;

public class HostListNamespaceResolver
implements DatasetNamespaceResolver {
    private final String resolvedName;
    private final HostListNamespaceResolverConfig config;

    public HostListNamespaceResolver(String resolvedName, HostListNamespaceResolverConfig config) {
        this.resolvedName = resolvedName;
        this.config = config;
    }

    @Override
    public String resolve(String namespace) {
        if (this.config.getHosts() == null) {
            return namespace;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.config.getSchema()) && !namespace.startsWith(this.config.getSchema() + "://")) {
            return namespace;
        }
        return this.config.getHosts().stream().filter(h -> StringUtils.containsIgnoreCase((CharSequence)namespace, (CharSequence)h)).findAny().map(h -> StringUtils.replaceIgnoreCase((String)namespace, (String)h, (String)this.resolvedName)).orElseGet(() -> namespace);
    }
}

