/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.dataset.namespace.resolver;

import io.openlineage.client.dataset.namespace.resolver.DatasetNamespaceResolver;
import io.openlineage.client.dataset.namespace.resolver.PatternNamespaceResolverConfig;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PatternNamespaceResolver
implements DatasetNamespaceResolver {
    private final String resolvedName;
    private final Pattern pattern;
    private final String schema;

    public PatternNamespaceResolver(String resolvedName, PatternNamespaceResolverConfig config) {
        this.resolvedName = resolvedName;
        this.pattern = Pattern.compile(config.getRegex());
        this.schema = config.getSchema();
    }

    @Override
    public String resolve(String namespace) {
        if (StringUtils.isNotEmpty((CharSequence)this.schema) && !namespace.startsWith(this.schema + "://")) {
            return namespace;
        }
        Matcher matcher = this.pattern.matcher(namespace);
        if (matcher.find()) {
            return matcher.replaceAll(this.resolvedName);
        }
        return namespace;
    }
}

