/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.utils.jdbc;

import io.openlineage.client.utils.jdbc.JdbcExtractor;
import io.openlineage.client.utils.jdbc.JdbcLocation;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SqlServerJdbcExtractor
implements JdbcExtractor {
    private static final String SCHEME = "sqlserver";
    private static final String SERVICE_PROPERTY = "servername";
    private static final String PORT_PROPERTY = "portnumber";
    private static final String INSTANCE_PROPERTY = "instancename";
    private static final String DATABASE_NAME_PROPERTY = "databasename";
    private static final String DATABASE_PROPERTY = "database";
    private static final Pattern URL = Pattern.compile("(?:\\w+)://(?<host>[\\w\\d\\.-]+)?(?:\\\\)?(?<instance>[\\w]+)?(?::)?(?<port>\\d+)?(?<params>.*)");

    @Override
    public boolean isDefinedAt(String jdbcUri) {
        return jdbcUri.toLowerCase(Locale.ROOT).startsWith(SCHEME);
    }

    @Override
    public JdbcLocation extract(String rawUri, Properties properties) throws URISyntaxException {
        String port;
        Matcher matcher = URL.matcher(rawUri);
        if (!matcher.matches()) {
            throw new URISyntaxException(rawUri, "Failed to parse jdbc url");
        }
        Properties finalProperties = new Properties();
        if (matcher.group("host") != null) {
            finalProperties.setProperty(SERVICE_PROPERTY, matcher.group("host"));
        }
        if (matcher.group("port") != null) {
            finalProperties.setProperty(PORT_PROPERTY, matcher.group("port"));
        }
        if (matcher.group("instance") != null) {
            finalProperties.setProperty(INSTANCE_PROPERTY, matcher.group("instance"));
        }
        String[] urlParams = StringUtils.defaultString((String)matcher.group("params")).replaceFirst(";", "").split(";");
        for (String urlParam : urlParams) {
            String[] parts = urlParam.split("=");
            if (parts.length != 2) continue;
            String key = parts[0].toLowerCase(Locale.ROOT);
            String value = parts[1];
            finalProperties.setProperty(key, value);
        }
        for (String key : properties.stringPropertyNames()) {
            String normalizedKey = key.toLowerCase(Locale.ROOT);
            if (finalProperties.getProperty(normalizedKey) != null) continue;
            finalProperties.setProperty(normalizedKey, properties.getProperty(key));
        }
        String host = finalProperties.getProperty(SERVICE_PROPERTY);
        if (host == null) {
            throw new URISyntaxException(rawUri, "Missing host");
        }
        if (host.contains(":") && !host.startsWith("[")) {
            host = "[" + host + "]";
        }
        String authority = (port = finalProperties.getProperty(PORT_PROPERTY)) != null ? host + ":" + port : host;
        Optional<String> instance = Optional.ofNullable(finalProperties.getProperty(INSTANCE_PROPERTY));
        Optional database = Optional.ofNullable(finalProperties.getProperty(DATABASE_NAME_PROPERTY)).map(Optional::of).orElseGet(() -> Optional.ofNullable(finalProperties.getProperty(DATABASE_PROPERTY)));
        return new JdbcLocation(SCHEME, Optional.of(authority), instance, database);
    }
}

