/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.filter.authorization;

import com.google.common.base.Preconditions;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationRequestContext;
import org.apache.gravitino.dto.requests.JobRunRequest;
import org.apache.gravitino.server.authorization.expression.AuthorizationExpressionEvaluator;
import org.apache.gravitino.server.web.filter.ParameterUtil;
import org.apache.gravitino.server.web.filter.authorization.AuthorizationExecutor;
import org.apache.gravitino.utils.NameIdentifierUtil;

public class RunJobAuthorizationExecutor
implements AuthorizationExecutor {
    private final Parameter[] parameters;
    private final Object[] args;
    private final Map<Entity.EntityType, NameIdentifier> metadataContext;
    private final AuthorizationExpressionEvaluator authorizationExpressionEvaluator;
    private final Map<String, Object> pathParams;
    private final String entityType;

    public RunJobAuthorizationExecutor(Parameter[] parameters, Object[] args, Map<Entity.EntityType, NameIdentifier> metadataContext, AuthorizationExpressionEvaluator authorizationExpressionEvaluator, Map<String, Object> pathParams, String entityType) {
        this.parameters = parameters;
        this.args = args;
        this.metadataContext = metadataContext;
        this.authorizationExpressionEvaluator = authorizationExpressionEvaluator;
        this.pathParams = pathParams;
        this.entityType = entityType;
    }

    @Override
    public boolean execute() throws Exception {
        Object request = ParameterUtil.extractFromParameters(this.parameters, this.args);
        if (request == null) {
            return false;
        }
        AuthorizationRequestContext context = new AuthorizationRequestContext();
        Preconditions.checkArgument((boolean)(request instanceof JobRunRequest), (String)"Expected JobRunRequest but found %s", (Object)request.getClass().getSimpleName());
        JobRunRequest jobRunRequest = (JobRunRequest)request;
        jobRunRequest.validate();
        String jobTemplateName = jobRunRequest.getJobTemplateName();
        NameIdentifier metalake = this.metadataContext.get(Entity.EntityType.METALAKE);
        NameIdentifier jobTemplateNameIdentifier = NameIdentifierUtil.ofJobTemplate((String)metalake.name(), (String)jobTemplateName);
        this.metadataContext.put(Entity.EntityType.JOB_TEMPLATE, jobTemplateNameIdentifier);
        return this.authorizationExpressionEvaluator.evaluate(this.metadataContext, this.pathParams, context, Optional.ofNullable(this.entityType));
    }
}

