/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.authorization.AccessControlDispatcher;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerDispatcher;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.dto.requests.UserAddRequest;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.responses.RemoveResponse;
import org.apache.gravitino.dto.responses.UserListResponse;
import org.apache.gravitino.dto.responses.UserResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.server.authorization.MetadataAuthzHelper;
import org.apache.gravitino.server.authorization.NameBindings;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NameBindings.AccessControlInterfaces
@Path(value="/metalakes/{metalake}/users")
public class UserOperations {
    private static final Logger LOG = LoggerFactory.getLogger(UserOperations.class);
    private static final String LOAD_USER_PRIVILEGE = "METALAKE::OWNER || METALAKE::MANAGE_USERS || USER::SELF";
    private final AccessControlDispatcher accessControlManager = GravitinoEnv.getInstance().accessControlDispatcher();
    private final OwnerDispatcher ownerManager = GravitinoEnv.getInstance().ownerDispatcher();
    @Context
    private HttpServletRequest httpRequest;

    @GET
    @Path(value="{user}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-user.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-user", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || METALAKE::MANAGE_USERS || USER::SELF")
    public Response getUser(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="user") @AuthorizationMetadata(type=Entity.EntityType.USER) String user) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> Utils.ok((Object)new UserResponse(DTOConverters.toDTO((User)this.accessControlManager.getUser(metalake, user)))));
        }
        catch (Exception e) {
            return ExceptionHandlers.handleUserException(OperationType.GET, user, metalake, e);
        }
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-user.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-user", absolute=true)
    @AuthorizationExpression(expression="")
    public Response listUsers(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @QueryParam(value="details") @DefaultValue(value="false") boolean verbose) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                if (verbose) {
                    Object[] users = this.accessControlManager.listUsers(metalake);
                    users = (User[])MetadataAuthzHelper.filterByExpression((String)metalake, (String)LOAD_USER_PRIVILEGE, (Entity.EntityType)Entity.EntityType.USER, (Object[])users, userEntity -> NameIdentifierUtil.ofUser((String)metalake, (String)userEntity.name()));
                    return Utils.ok((Object)new UserListResponse(DTOConverters.toDTOs((User[])users)));
                }
                Object[] users = this.accessControlManager.listUserNames(metalake);
                users = (String[])MetadataAuthzHelper.filterByExpression((String)metalake, (String)LOAD_USER_PRIVILEGE, (Entity.EntityType)Entity.EntityType.USER, (Object[])users, username -> NameIdentifierUtil.ofUser((String)metalake, (String)username));
                return Utils.ok((Object)new NameListResponse((String[])users));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleUserException(OperationType.LIST, "", metalake, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="add-user.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="add-user", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || METALAKE::MANAGE_USERS")
    public Response addUser(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, UserAddRequest request) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                return Utils.ok((Object)new UserResponse(DTOConverters.toDTO((User)this.accessControlManager.addUser(metalake, request.getName()))));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleUserException(OperationType.ADD, request.getName(), metalake, e);
        }
    }

    @DELETE
    @Path(value="{user}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="remove-user.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="remove-user", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || METALAKE::MANAGE_USERS")
    public Response removeUser(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="user") String user) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                this.ownerManager.getOwner(metalake, MetadataObjects.of(null, (String)metalake, (MetadataObject.Type)MetadataObject.Type.METALAKE)).ifPresent(owner -> {
                    if (owner.type() == Owner.Type.USER && owner.name().equals(user)) {
                        throw new IllegalArgumentException(String.format("Cannot remove user %s from metalake %s because the user is the owner of the metalake.", user, metalake));
                    }
                });
                boolean removed = this.accessControlManager.removeUser(metalake, user);
                if (!removed) {
                    LOG.warn("Failed to remove user {} under metalake {}", (Object)user, (Object)metalake);
                }
                return Utils.ok((Object)new RemoveResponse(removed));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleUserException(OperationType.REMOVE, user, metalake, e);
        }
    }
}

