/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.commons.configuration2.builder;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.hadoop.shaded.org.apache.commons.configuration2.ConfigurationUtils;
import org.apache.hadoop.shaded.org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.hadoop.shaded.org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.hadoop.shaded.org.apache.commons.configuration2.event.EventSource;

public class BuilderConfigurationWrapperFactory {
    private final EventSourceSupport eventSourceSupport;

    public BuilderConfigurationWrapperFactory(EventSourceSupport evSrcSupport) {
        this.eventSourceSupport = evSrcSupport;
    }

    public BuilderConfigurationWrapperFactory() {
        this(EventSourceSupport.NONE);
    }

    public <T extends ImmutableConfiguration> T createBuilderConfigurationWrapper(Class<T> ifcClass, ConfigurationBuilder<? extends T> builder) {
        return BuilderConfigurationWrapperFactory.createBuilderConfigurationWrapper(ifcClass, builder, this.getEventSourceSupport());
    }

    public EventSourceSupport getEventSourceSupport() {
        return this.eventSourceSupport;
    }

    public static <T extends ImmutableConfiguration> T createBuilderConfigurationWrapper(Class<T> ifcClass, ConfigurationBuilder<? extends T> builder, EventSourceSupport evSrcSupport) {
        if (ifcClass == null) {
            throw new IllegalArgumentException("Interface class must not be null!");
        }
        if (builder == null) {
            throw new IllegalArgumentException("Builder must not be null!");
        }
        return (T)((ImmutableConfiguration)ifcClass.cast(Proxy.newProxyInstance(BuilderConfigurationWrapperFactory.class.getClassLoader(), BuilderConfigurationWrapperFactory.fetchSupportedInterfaces(ifcClass, evSrcSupport), (InvocationHandler)new BuilderConfigurationWrapperInvocationHandler(builder, evSrcSupport))));
    }

    private static Class<?>[] fetchSupportedInterfaces(Class<?> ifcClass, EventSourceSupport evSrcSupport) {
        if (EventSourceSupport.NONE == evSrcSupport) {
            return new Class[]{ifcClass};
        }
        Class[] result = new Class[]{EventSource.class, ifcClass};
        return result;
    }

    private static class BuilderConfigurationWrapperInvocationHandler
    implements InvocationHandler {
        private final ConfigurationBuilder<? extends ImmutableConfiguration> builder;
        private final EventSourceSupport eventSourceSupport;

        public BuilderConfigurationWrapperInvocationHandler(ConfigurationBuilder<? extends ImmutableConfiguration> wrappedBuilder, EventSourceSupport evSrcSupport) {
            this.builder = wrappedBuilder;
            this.eventSourceSupport = evSrcSupport;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (EventSource.class.equals(method.getDeclaringClass())) {
                return this.handleEventSourceInvocation(method, args);
            }
            return this.handleConfigurationInvocation(method, args);
        }

        private Object handleConfigurationInvocation(Method method, Object[] args) throws Exception {
            return method.invoke((Object)this.builder.getConfiguration(), args);
        }

        private Object handleEventSourceInvocation(Method method, Object[] args) throws Exception {
            EventSource target = EventSourceSupport.DUMMY == this.eventSourceSupport ? ConfigurationUtils.asEventSource(this, true) : this.builder;
            return method.invoke(target, args);
        }
    }

    public static enum EventSourceSupport {
        NONE,
        DUMMY,
        BUILDER;

    }
}

