/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.s3.fs;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import java.net.URI;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemUtils;
import org.apache.gravitino.catalog.hadoop.fs.GravitinoFileSystemCredentialsProvider;
import org.apache.gravitino.credential.AwsIrsaCredential;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.S3SecretKeyCredential;
import org.apache.gravitino.credential.S3TokenCredential;
import org.apache.gravitino.s3.fs.S3Utils;
import org.apache.hadoop.conf.Configuration;

public class S3CredentialsProvider
implements AWSCredentialsProvider {
    private GravitinoFileSystemCredentialsProvider gravitinoFileSystemCredentialsProvider;
    private AWSCredentials basicSessionCredentials;
    private long expirationTime = Long.MAX_VALUE;
    private static final double EXPIRATION_TIME_FACTOR = 0.5;

    public S3CredentialsProvider(URI uri, Configuration conf) {
        this.gravitinoFileSystemCredentialsProvider = FileSystemUtils.getGvfsCredentialProvider((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWSCredentials getCredentials() {
        if (this.basicSessionCredentials == null || System.currentTimeMillis() >= this.expirationTime) {
            S3CredentialsProvider s3CredentialsProvider = this;
            synchronized (s3CredentialsProvider) {
                this.refresh();
            }
        }
        return this.basicSessionCredentials;
    }

    public void refresh() {
        Credential[] gravitinoCredentials = this.gravitinoFileSystemCredentialsProvider.getCredentials();
        Credential credential = S3Utils.getSuitableCredential(gravitinoCredentials);
        if (credential == null) {
            throw new RuntimeException("No suitable credential for S3 found...");
        }
        if (credential instanceof S3SecretKeyCredential) {
            S3SecretKeyCredential s3SecretKeyCredential = (S3SecretKeyCredential)credential;
            this.basicSessionCredentials = new BasicAWSCredentials(s3SecretKeyCredential.accessKeyId(), s3SecretKeyCredential.secretAccessKey());
        } else if (credential instanceof S3TokenCredential) {
            S3TokenCredential s3TokenCredential = (S3TokenCredential)credential;
            this.basicSessionCredentials = new BasicSessionCredentials(s3TokenCredential.accessKeyId(), s3TokenCredential.secretAccessKey(), s3TokenCredential.sessionToken());
        } else if (credential instanceof AwsIrsaCredential) {
            AwsIrsaCredential awsIrsaCredential = (AwsIrsaCredential)credential;
            this.basicSessionCredentials = new BasicSessionCredentials(awsIrsaCredential.accessKeyId(), awsIrsaCredential.secretAccessKey(), awsIrsaCredential.sessionToken());
        }
        if (credential.expireTimeInMs() > 0L) {
            this.expirationTime = System.currentTimeMillis() + (long)((double)(credential.expireTimeInMs() - System.currentTimeMillis()) * 0.5);
        }
    }
}

