/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.generic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.catalog.ManagedSchemaOperations;
import org.apache.gravitino.catalog.ManagedTableOperations;
import org.apache.gravitino.catalog.lakehouse.generic.LakehouseTableDelegator;
import org.apache.gravitino.catalog.lakehouse.generic.LakehouseTableDelegatorFactory;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.SupportsSchemas;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableCatalog;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.storage.IdGenerator;

public class GenericCatalogOperations
implements CatalogOperations,
SupportsSchemas,
TableCatalog {
    private static final String SLASH = "/";
    private final ManagedSchemaOperations schemaOps;
    private final Map<String, Supplier<ManagedTableOperations>> tableOpsCache;
    private Optional<String> catalogLocation;
    private HasPropertyMetadata propertiesMetadata;
    private final Cache<NameIdentifier, String> tableFormatCache;
    private final EntityStore store;

    public GenericCatalogOperations() {
        this(GravitinoEnv.getInstance().entityStore(), GravitinoEnv.getInstance().idGenerator());
    }

    @VisibleForTesting
    GenericCatalogOperations(final EntityStore store, IdGenerator idGenerator) {
        this.store = store;
        this.schemaOps = new ManagedSchemaOperations(){

            protected EntityStore store() {
                return store;
            }
        };
        this.tableFormatCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
        ImmutableMap<String, LakehouseTableDelegator> tableDelegators = LakehouseTableDelegatorFactory.tableDelegators();
        this.tableOpsCache = Collections.unmodifiableMap(tableDelegators.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            LakehouseTableDelegator delegator = (LakehouseTableDelegator)e.getValue();
            return Suppliers.memoize(() -> delegator.createTableOps(store, this.schemaOps, idGenerator));
        })));
        if (this.tableOpsCache.isEmpty()) {
            throw new IllegalArgumentException("No table delegators found, this is unexpected.");
        }
    }

    public void initialize(Map<String, String> conf, CatalogInfo info, HasPropertyMetadata propertiesMetadata) throws RuntimeException {
        String location = (String)propertiesMetadata.catalogPropertiesMetadata().getOrDefault(conf, "location");
        this.catalogLocation = StringUtils.isNotBlank((CharSequence)location) ? Optional.of(location).map(this::ensureTrailingSlash) : Optional.empty();
        this.propertiesMetadata = propertiesMetadata;
    }

    public void close() {
        this.tableFormatCache.cleanUp();
    }

    public void testConnection(NameIdentifier catalogIdent, Catalog.Type type, String provider, String comment, Map<String, String> properties) {
    }

    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        return this.schemaOps.listSchemas(namespace);
    }

    public Schema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        return this.schemaOps.createSchema(ident, comment, properties);
    }

    public Schema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        return this.schemaOps.loadSchema(ident);
    }

    public Schema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        return this.schemaOps.alterSchema(ident, changes);
    }

    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        NameIdentifier[] tableIdents;
        Namespace tableNs = Namespace.of((String[])new String[]{ident.namespace().level(0), ident.namespace().level(1), ident.name()});
        try {
            tableIdents = this.listTables(tableNs);
        }
        catch (NoSuchSchemaException e) {
            return false;
        }
        if (!cascade && tableIdents.length > 0) {
            throw new NonEmptySchemaException("Schema %s is not empty, cannot drop it without cascade", new Object[]{ident});
        }
        for (NameIdentifier tableIdent : tableIdents) {
            this.tableOps(tableIdent).dropTable(tableIdent);
        }
        return this.schemaOps.dropSchema(ident, cascade);
    }

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        ManagedTableOperations tableOps = this.tableOpsCache.values().iterator().next().get();
        return tableOps.listTables(namespace);
    }

    public Table loadTable(NameIdentifier ident) throws NoSuchTableException {
        Table loadedTable = this.tableOps(ident).loadTable(ident);
        Optional<String> tableFormat = Optional.ofNullable(loadedTable.properties().getOrDefault("format", null)).map(s -> s.toLowerCase(Locale.ROOT));
        tableFormat.ifPresent(s -> this.tableFormatCache.put((Object)ident, s));
        return loadedTable;
    }

    public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        Schema schema = this.loadSchema(NameIdentifier.of((String[])ident.namespace().levels()));
        String tableLocation = this.calculateTableLocation(schema, ident, properties);
        String format = properties.getOrDefault("format", null);
        Preconditions.checkArgument((format != null ? 1 : 0) != 0, (Object)"Table format must be specified in table properties");
        format = format.toLowerCase(Locale.ROOT);
        HashMap newProperties = Maps.newHashMap(properties);
        newProperties.put("location", tableLocation);
        newProperties.put("format", format);
        Supplier<ManagedTableOperations> tableOpsSupplier = this.tableOpsCache.get(format);
        Preconditions.checkArgument((tableOpsSupplier != null ? 1 : 0) != 0, (String)"Unsupported table format: %s", (Object)format);
        ManagedTableOperations tableOps = tableOpsSupplier.get();
        Table createdTable = tableOps.createTable(ident, columns, comment, (Map)newProperties, partitions, distribution, sortOrders, indexes);
        this.tableFormatCache.put((Object)ident, (Object)format);
        return createdTable;
    }

    public Table alterTable(NameIdentifier ident, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        Table alteredTable = this.tableOps(ident).alterTable(ident, changes);
        boolean isRenameChange = Arrays.stream(changes).anyMatch(c -> c instanceof TableChange.RenameTable);
        if (isRenameChange) {
            this.tableFormatCache.invalidate((Object)ident);
        }
        return alteredTable;
    }

    public boolean purgeTable(NameIdentifier ident) {
        boolean purged = this.tableOps(ident).purgeTable(ident);
        this.tableFormatCache.invalidate((Object)ident);
        return purged;
    }

    public boolean dropTable(NameIdentifier ident) throws UnsupportedOperationException {
        boolean dropped = this.tableOps(ident).dropTable(ident);
        this.tableFormatCache.invalidate((Object)ident);
        return dropped;
    }

    private String calculateTableLocation(Schema schema, NameIdentifier tableIdent, Map<String, String> tableProperties) {
        String schemaLocation;
        String tableLocation = (String)this.propertiesMetadata.tablePropertiesMetadata().getOrDefault(tableProperties, "location");
        if (StringUtils.isNotBlank((CharSequence)tableLocation)) {
            return this.ensureTrailingSlash(tableLocation);
        }
        String string = schemaLocation = schema.properties() == null ? null : (String)schema.properties().get("location");
        if (StringUtils.isNotBlank(schemaLocation)) {
            return this.ensureTrailingSlash(schemaLocation) + tableIdent.name() + SLASH;
        }
        if (this.catalogLocation.isEmpty()) {
            throw new IllegalArgumentException("'location' property is neither set in table properties nor in schema properties, and no location is set in catalog properties either. Please set the 'location' in either of them to create the table " + String.valueOf(tableIdent));
        }
        return this.ensureTrailingSlash(this.catalogLocation.get()) + tableIdent.namespace().level(2) + SLASH + tableIdent.name() + SLASH;
    }

    private String ensureTrailingSlash(String path) {
        return path.endsWith(SLASH) ? path : path + SLASH;
    }

    private ManagedTableOperations tableOps(NameIdentifier tableIdent) {
        try {
            String tableFormat = (String)this.tableFormatCache.get((Object)tableIdent, () -> {
                TableEntity table = (TableEntity)this.store.get(tableIdent, Entity.EntityType.TABLE, TableEntity.class);
                String format = table.properties().getOrDefault("format", null);
                Preconditions.checkArgument((format != null ? 1 : 0) != 0, (String)"Table format for %s is null, this is unexpected", (Object)tableIdent);
                return format.toLowerCase(Locale.ROOT);
            });
            ManagedTableOperations ops = this.tableOpsCache.get(tableFormat).get();
            Preconditions.checkArgument((ops != null ? 1 : 0) != 0, (String)"No table operations found for table format %s", (Object)tableFormat);
            return ops;
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (t instanceof NoSuchEntityException) {
                throw new NoSuchTableException("Table %s does not exist", new Object[]{tableIdent});
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            if (t instanceof IOException) {
                throw new RuntimeException(String.format("Failed to load table %s: %s", tableIdent, t.getMessage()), t);
            }
            throw new RuntimeException(String.format("Unexpected exception when loading table %s", tableIdent), t);
        }
    }
}

