/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.catalog.hive.TableType;
import org.apache.gravitino.connector.BaseTable;
import org.apache.gravitino.connector.ProxyPlugin;
import org.apache.gravitino.connector.TableOperations;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;

public class HiveTable
extends BaseTable {
    public static final Set<String> SUPPORT_TABLE_TYPES = Sets.newHashSet((Object[])new String[]{TableType.MANAGED_TABLE.name(), TableType.EXTERNAL_TABLE.name()});
    public static final String ICEBERG_TABLE_TYPE_VALUE = "ICEBERG";
    public static final String TABLE_TYPE_PROP = "table_type";
    private String catalogName;
    private String databaseName;

    protected HiveTable() {
    }

    public String catalogName() {
        return this.catalogName;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public void setProxyPlugin(ProxyPlugin plugin) {
        this.proxyPlugin = Optional.ofNullable(plugin);
    }

    protected TableOperations newOps() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> partitionFieldNames() {
        if (this.partitioning() == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.partitioning()).flatMap(transform -> HiveTable.extractPartitionFieldNames(transform).stream()).collect(Collectors.toList());
    }

    private static List<String> extractPartitionFieldNames(Transform partitioning) {
        Expression expression;
        if (partitioning instanceof Transforms.IdentityTransform) {
            return Arrays.asList(((Transforms.IdentityTransform)partitioning).fieldName());
        }
        if (partitioning.arguments().length > 0 && (expression = partitioning.arguments()[0]) instanceof NamedReference.FieldReference) {
            NamedReference.FieldReference fieldReference = (NamedReference.FieldReference)expression;
            return Arrays.asList(fieldReference.fieldName());
        }
        throw new IllegalArgumentException(String.format("Unsupported partition transform type: %s", partitioning.getClass()));
    }

    public String toString() {
        return "HiveTable(catalogName=" + this.catalogName + ", databaseName=" + this.databaseName + ")";
    }

    static /* synthetic */ Column[] access$402(HiveTable x0, Column[] x1) {
        x0.columns = x1;
        return x1;
    }

    static /* synthetic */ SortOrder[] access$602(HiveTable x0, SortOrder[] x1) {
        x0.sortOrders = x1;
        return x1;
    }

    static /* synthetic */ Transform[] access$702(HiveTable x0, Transform[] x1) {
        x0.partitioning = x1;
        return x1;
    }

    public static class Builder
    extends BaseTable.BaseTableBuilder<Builder, HiveTable> {
        private String catalogName;
        private String databaseName;

        private Builder() {
        }

        public Builder withCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        protected HiveTable internalBuild() {
            HiveTable hiveTable = new HiveTable();
            hiveTable.name = this.name;
            hiveTable.comment = this.comment;
            hiveTable.properties = this.properties != null ? Maps.newHashMap((Map)this.properties) : Maps.newHashMap();
            hiveTable.auditInfo = this.auditInfo;
            HiveTable.access$402(hiveTable, this.columns);
            hiveTable.distribution = this.distribution;
            HiveTable.access$602(hiveTable, this.sortOrders);
            HiveTable.access$702(hiveTable, this.partitioning);
            hiveTable.catalogName = this.catalogName;
            hiveTable.databaseName = this.databaseName;
            hiveTable.proxyPlugin = this.proxyPlugin;
            if (this.comment != null) {
                hiveTable.properties.put("comment", this.comment);
            }
            return hiveTable;
        }
    }
}

