/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.gravitino.hive.CachedClientPool;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CachedClientPool.ConfElement", generator="Immutables")
@Immutable
final class ImmutableConfElement
extends CachedClientPool.ConfElement {
    private final String key;
    @Nullable
    private final String value;

    private ImmutableConfElement(String key, @Nullable String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    String key() {
        return this.key;
    }

    @Override
    @Nullable
    String value() {
        return this.value;
    }

    public final ImmutableConfElement withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableConfElement(newValue, this.value);
    }

    public final ImmutableConfElement withValue(@Nullable String value) {
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return new ImmutableConfElement(this.key, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfElement && this.equalsByValue((ImmutableConfElement)another);
    }

    private boolean equalsByValue(ImmutableConfElement another) {
        return this.key.equals(another.key) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConfElement").omitNullValues().add("key", (Object)this.key).add("value", (Object)this.value).toString();
    }

    public static ImmutableConfElement copyOf(CachedClientPool.ConfElement instance) {
        if (instance instanceof ImmutableConfElement) {
            return (ImmutableConfElement)instance;
        }
        return ImmutableConfElement.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CachedClientPool.ConfElement", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private long initBits = 1L;
        @Nullable
        private String key;
        @Nullable
        private String value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CachedClientPool.ConfElement instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            String valueValue = instance.value();
            if (valueValue != null) {
                this.value(valueValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(@Nullable String value) {
            this.value = value;
            return this;
        }

        public ImmutableConfElement build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfElement(this.key, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build ConfElement, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

