/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.util.AtomicFileOutputStream;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class PersistentLongFile {
    private static final Log LOG = LogFactory.getLog(PersistentLongFile.class);
    private final File file;
    private final long defaultVal;
    private long value;
    private boolean loaded = false;

    public PersistentLongFile(File file, long defaultVal) {
        this.file = file;
        this.defaultVal = defaultVal;
    }

    public long get() throws IOException {
        if (!this.loaded) {
            this.value = PersistentLongFile.readFile(this.file, this.defaultVal);
            this.loaded = true;
        }
        return this.value;
    }

    public void set(long newVal) throws IOException {
        if (this.value != newVal || !this.loaded) {
            PersistentLongFile.writeFile(this.file, newVal);
        }
        this.value = newVal;
        this.loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, long val) throws IOException {
        AtomicFileOutputStream fos = new AtomicFileOutputStream(file);
        try {
            fos.write(String.valueOf(val).getBytes(Charsets.UTF_8));
            fos.write(10);
            fos.close();
            fos = null;
        }
        finally {
            if (fos != null) {
                fos.abort();
            }
        }
    }

    public static long readFile(File file, long defaultVal) throws IOException {
        long val = defaultVal;
        if (file.exists()) {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));
            try {
                val = Long.parseLong(br.readLine());
                br.close();
                br = null;
            }
            catch (NumberFormatException e) {
                try {
                    throw new IOException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{br});
                    throw throwable;
                }
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{br});
        }
        return val;
    }
}

