/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.CapabilityHelpers;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.EntityCombinedTable;
import org.apache.gravitino.catalog.OperationDispatcher;
import org.apache.gravitino.catalog.PropertiesMetadataHelpers;
import org.apache.gravitino.catalog.SchemaDispatcher;
import org.apache.gravitino.catalog.TableDispatcher;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.ColumnEntity;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableOperationDispatcher
extends OperationDispatcher
implements TableDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(TableOperationDispatcher.class);

    public TableOperationDispatcher(CatalogManager catalogManager, EntityStore store, IdGenerator idGenerator) {
        super(catalogManager, store, idGenerator);
    }

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        return TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])namespace.levels()), LockType.READ, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(NameIdentifier.of((String[])namespace.levels())), c -> c.doWithTableOps(t -> t.listTables(namespace)), NoSuchSchemaException.class));
    }

    public Table loadTable(NameIdentifier ident) throws NoSuchTableException {
        EntityCombinedTable entityCombinedTable = TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.internalLoadTable(ident));
        if (!entityCombinedTable.imported()) {
            SchemaDispatcher schemaDispatcher = GravitinoEnv.getInstance().schemaDispatcher();
            NameIdentifier schemaIdent = NameIdentifier.of((String[])ident.namespace().levels());
            schemaDispatcher.loadSchema(schemaIdent);
            entityCombinedTable = TreeLockUtils.doWithTreeLock(schemaIdent, LockType.WRITE, () -> this.importTable(ident));
        }
        TableEntity updatedEntity = this.updateColumnsIfNecessaryWhenLoad(ident, entityCombinedTable);
        return EntityCombinedTable.of(entityCombinedTable.tableFromCatalog(), updatedEntity).withHiddenProperties(this.getHiddenPropertyNames(NameIdentifierUtil.getCatalogIdentifier(ident), HasPropertyMetadata::tablePropertiesMetadata, entityCombinedTable.tableFromCatalog().properties())).withImported(entityCombinedTable.imported());
    }

    public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        SchemaDispatcher schemaDispatcher = GravitinoEnv.getInstance().schemaDispatcher();
        NameIdentifier schemaIdent = NameIdentifier.of((String[])ident.namespace().levels());
        schemaDispatcher.loadSchema(schemaIdent);
        return TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])ident.namespace().levels()), LockType.WRITE, () -> this.internalCreateTable(ident, columns, comment, properties, partitions, distribution, sortOrders, indexes));
    }

    public Table alterTable(NameIdentifier ident, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        this.validateAlterProperties(ident, HasPropertyMetadata::tablePropertiesMetadata, changes);
        NameIdentifier nameIdentifierForLock = ident;
        String schemaName = ident.namespace().level(2);
        for (TableChange change : changes) {
            if (!(change instanceof TableChange.RenameTable)) continue;
            TableChange.RenameTable rename = (TableChange.RenameTable)change;
            if (rename.getNewSchemaName().isPresent() && !((String)rename.getNewSchemaName().get()).equals(schemaName)) {
                nameIdentifierForLock = NameIdentifierUtil.getCatalogIdentifier(ident);
                break;
            }
            nameIdentifierForLock = NameIdentifierUtil.getSchemaIdentifier(ident);
        }
        return TreeLockUtils.doWithTreeLock(nameIdentifierForLock, nameIdentifierForLock.equals((Object)ident) ? LockType.READ : LockType.WRITE, () -> {
            NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
            Table alteredTable = this.doWithCatalog(catalogIdent, c -> c.doWithTableOps(t -> t.alterTable(ident, CapabilityHelpers.applyCapabilities(c.capabilities(), changes))), NoSuchTableException.class, IllegalArgumentException.class);
            boolean isManagedTable = this.isManagedEntity(catalogIdent, Capability.Scope.TABLE);
            if (isManagedTable) {
                return EntityCombinedTable.of(alteredTable).withHiddenProperties(this.getHiddenPropertyNames(NameIdentifierUtil.getCatalogIdentifier(ident), HasPropertyMetadata::tablePropertiesMetadata, alteredTable.properties()));
            }
            StringIdentifier stringId = this.getStringIdFromProperties(alteredTable.properties());
            TableEntity te = null;
            if (stringId == null && (te = this.getEntity(ident, Entity.EntityType.TABLE, TableEntity.class)) == null) {
                return EntityCombinedTable.of(alteredTable).withHiddenProperties(this.getHiddenPropertyNames(NameIdentifierUtil.getCatalogIdentifier(ident), HasPropertyMetadata::tablePropertiesMetadata, alteredTable.properties()));
            }
            long tableId = stringId != null ? stringId.id() : te.id().longValue();
            TableEntity updatedTableEntity = this.operateOnEntity(ident, id -> this.store.update((NameIdentifier)id, TableEntity.class, Entity.EntityType.TABLE, tableEntity -> {
                Namespace newNamespace = this.getNewNamespace(ident, changes);
                Pair<Boolean, List<ColumnEntity>> columnsUpdateResult = this.updateColumnsIfNecessary(alteredTable, (TableEntity)tableEntity);
                return TableEntity.builder().withId(tableEntity.id()).withName(alteredTable.name()).withNamespace(newNamespace).withColumns((List)columnsUpdateResult.getRight()).withAuditInfo(AuditInfo.builder().withCreator(tableEntity.auditInfo().creator()).withCreateTime(tableEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build()).build();
            }), "UPDATE", tableId);
            return EntityCombinedTable.of(alteredTable, updatedTableEntity).withHiddenProperties(this.getHiddenPropertyNames(NameIdentifierUtil.getCatalogIdentifier(ident), HasPropertyMetadata::tablePropertiesMetadata, alteredTable.properties()));
        });
    }

    public boolean dropTable(NameIdentifier ident) {
        NameIdentifier schemaIdentifier = NameIdentifierUtil.getSchemaIdentifier(ident);
        return TreeLockUtils.doWithTreeLock(schemaIdentifier, LockType.WRITE, () -> {
            NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
            boolean droppedFromCatalog = this.doWithCatalog(catalogIdent, c -> c.doWithTableOps(t -> t.dropTable(ident)), RuntimeException.class);
            boolean isManagedTable = this.isManagedEntity(catalogIdent, Capability.Scope.TABLE);
            if (isManagedTable) {
                return droppedFromCatalog;
            }
            try {
                this.store.delete(ident, Entity.EntityType.TABLE);
            }
            catch (NoSuchEntityException e) {
                LOG.warn("The table to be dropped does not exist in the store: {}", (Object)ident, (Object)e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return droppedFromCatalog;
        });
    }

    public boolean purgeTable(NameIdentifier ident) throws UnsupportedOperationException {
        NameIdentifier schemaIdentifier = NameIdentifierUtil.getSchemaIdentifier(ident);
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        return TreeLockUtils.doWithTreeLock(schemaIdentifier, LockType.WRITE, () -> {
            boolean droppedFromCatalog = this.doWithCatalog(catalogIdent, c -> c.doWithTableOps(t -> t.purgeTable(ident)), RuntimeException.class, UnsupportedOperationException.class);
            boolean isManagedTable = this.isManagedEntity(catalogIdent, Capability.Scope.TABLE);
            if (isManagedTable) {
                return droppedFromCatalog;
            }
            try {
                this.store.delete(ident, Entity.EntityType.TABLE);
            }
            catch (NoSuchEntityException e) {
                LOG.warn("The table to be purged does not exist in the store: {}", (Object)ident, (Object)e);
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return droppedFromCatalog;
        });
    }

    private Namespace getNewNamespace(NameIdentifier tableIdent, TableChange ... changes) {
        String schemaName = tableIdent.namespace().level(2);
        return Arrays.stream(changes).filter(c -> c instanceof TableChange.RenameTable && ((TableChange.RenameTable)c).getNewSchemaName().isPresent() && !((String)((TableChange.RenameTable)c).getNewSchemaName().get()).equals(schemaName)).map(c -> NamespaceUtil.ofTable(tableIdent.namespace().level(0), tableIdent.namespace().level(1), (String)((TableChange.RenameTable)c).getNewSchemaName().get())).reduce((c1, c2) -> c2).orElse(tableIdent.namespace());
    }

    private EntityCombinedTable importTable(NameIdentifier identifier) {
        long uid;
        EntityCombinedTable table = this.internalLoadTable(identifier);
        if (table.imported()) {
            return table;
        }
        StringIdentifier stringId = null;
        try {
            stringId = table.stringIdentifier();
        }
        catch (IllegalArgumentException ie) {
            LOG.warn("Failed to get string identifier from schema properties: {}, this maybe caused by the same-name string identifier is set by the user with unsupported format.", (Object)ie.getMessage());
        }
        if (stringId != null) {
            LOG.warn("The Table uid {} existed but still need to be imported, this could be happened when Table is renamed by external systems not controlled by Gravitino. In this case, we need to overwrite the stored entity to keep the consistency.", (Object)stringId);
            uid = stringId.id();
        } else {
            uid = this.idGenerator.nextId();
        }
        AuditInfo audit = AuditInfo.builder().withCreator(table.auditInfo().creator()).withCreateTime(table.auditInfo().createTime()).withLastModifier(table.auditInfo().lastModifier()).withLastModifiedTime(table.auditInfo().lastModifiedTime()).build();
        List<ColumnEntity> columnEntityList = this.toColumnEntities(table.tableFromCatalog().columns(), audit);
        TableEntity tableEntity = TableEntity.builder().withId(uid).withName(identifier.name()).withNamespace(identifier.namespace()).withColumns(columnEntityList).withAuditInfo(audit).build();
        try {
            this.store.put(tableEntity, true);
        }
        catch (EntityAlreadyExistsException e) {
            LOG.error("Failed to import table {} with id {} to the store.", new Object[]{identifier, uid, e});
            throw new UnsupportedOperationException("Table managed by multiple catalogs. This may cause unexpected issues such as privilege conflicts. To resolve: Remove all catalogs managing this table, then recreate one catalog to ensure single-catalog management.");
        }
        catch (Exception e) {
            LOG.error("Failed to {} entity for {} in Gravitino, with this situation the returned object will not contain the metadata from Gravitino.", new Object[]{"put", identifier, e});
            throw new RuntimeException("Fail to import the table entity to the store.", e);
        }
        return EntityCombinedTable.of(table.tableFromCatalog(), tableEntity).withHiddenProperties(this.getHiddenPropertyNames(NameIdentifierUtil.getCatalogIdentifier(identifier), HasPropertyMetadata::tablePropertiesMetadata, table.tableFromCatalog().properties()));
    }

    private EntityCombinedTable internalLoadTable(NameIdentifier ident) {
        NameIdentifier catalogIdentifier = NameIdentifierUtil.getCatalogIdentifier(ident);
        Table table = this.doWithCatalog(catalogIdentifier, c -> c.doWithTableOps(t -> t.loadTable(ident)), NoSuchTableException.class);
        boolean isManagedTable = this.isManagedEntity(catalogIdentifier, Capability.Scope.TABLE);
        if (isManagedTable) {
            return EntityCombinedTable.of(table).withHiddenProperties(this.getHiddenPropertyNames(catalogIdentifier, HasPropertyMetadata::tablePropertiesMetadata, table.properties())).withImported(true);
        }
        StringIdentifier stringId = this.getStringIdFromProperties(table.properties());
        if (stringId == null) {
            TableEntity tableEntity = this.getEntity(ident, Entity.EntityType.TABLE, TableEntity.class);
            if (tableEntity == null) {
                return EntityCombinedTable.of(table).withHiddenProperties(this.getHiddenPropertyNames(catalogIdentifier, HasPropertyMetadata::tablePropertiesMetadata, table.properties())).withImported(false);
            }
            return EntityCombinedTable.of(table, tableEntity).withHiddenProperties(this.getHiddenPropertyNames(catalogIdentifier, HasPropertyMetadata::tablePropertiesMetadata, table.properties())).withImported(true);
        }
        TableEntity tableEntity = this.operateOnEntity(ident, identifier -> this.store.get((NameIdentifier)identifier, Entity.EntityType.TABLE, TableEntity.class), "GET", stringId.id());
        return EntityCombinedTable.of(table, tableEntity).withHiddenProperties(this.getHiddenPropertyNames(catalogIdentifier, HasPropertyMetadata::tablePropertiesMetadata, table.properties())).withImported(tableEntity != null);
    }

    private Table internalCreateTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        this.doWithCatalog(catalogIdent, c -> c.doWithPropertiesMeta(p -> {
            PropertiesMetadataHelpers.validatePropertyForCreate(p.tablePropertiesMetadata(), properties);
            return null;
        }), IllegalArgumentException.class);
        long uid = this.idGenerator.nextId();
        StringIdentifier stringId = StringIdentifier.fromId(uid);
        Map<String, String> updatedProperties = StringIdentifier.newPropertiesWithId(stringId, properties);
        Table table = this.doWithCatalog(catalogIdent, c -> c.doWithTableOps(t -> t.createTable(ident, columns, comment, updatedProperties, partitions == null ? Transforms.EMPTY_TRANSFORM : partitions, distribution == null ? Distributions.NONE : distribution, sortOrders == null ? new SortOrder[]{} : sortOrders, indexes == null ? Indexes.EMPTY_INDEXES : indexes)), NoSuchSchemaException.class, TableAlreadyExistsException.class);
        boolean isManagedTable = this.isManagedEntity(catalogIdent, Capability.Scope.TABLE);
        if (isManagedTable) {
            return EntityCombinedTable.of(table).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::tablePropertiesMetadata, table.properties()));
        }
        AuditInfo audit = AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build();
        List<ColumnEntity> columnEntityList = IntStream.range(0, columns.length).mapToObj(i -> ColumnEntity.toColumnEntity(columns[i], i, this.idGenerator.nextId(), audit)).collect(Collectors.toList());
        TableEntity tableEntity = TableEntity.builder().withId(uid).withName(ident.name()).withNamespace(ident.namespace()).withColumns(columnEntityList).withAuditInfo(audit).build();
        try {
            this.store.put(tableEntity, true);
        }
        catch (Exception e) {
            LOG.error("Failed to {} entity for {} in Gravitino, with this situation the returned object will not contain the metadata from Gravitino.", new Object[]{"put", ident, e});
            return EntityCombinedTable.of(table).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::tablePropertiesMetadata, table.properties()));
        }
        return EntityCombinedTable.of(table, tableEntity).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::tablePropertiesMetadata, table.properties()));
    }

    private List<ColumnEntity> toColumnEntities(Column[] columns, AuditInfo audit) {
        return columns == null ? Collections.emptyList() : IntStream.range(0, columns.length).mapToObj(i -> ColumnEntity.toColumnEntity(columns[i], i, this.idGenerator.nextId(), audit)).collect(Collectors.toList());
    }

    private boolean isSameColumn(Column left, int columnPosition, ColumnEntity right) {
        return Objects.equal((Object)left.name(), (Object)right.name()) && columnPosition == right.position() && Objects.equal((Object)left.dataType(), (Object)right.dataType()) && Objects.equal((Object)left.comment(), (Object)right.comment()) && left.nullable() == right.nullable() && left.autoIncrement() == right.autoIncrement() && Objects.equal((Object)left.defaultValue(), (Object)right.defaultValue());
    }

    private Pair<Boolean, List<ColumnEntity>> updateColumnsIfNecessary(Table tableFromCatalog, TableEntity tableFromGravitino) {
        if (tableFromCatalog == null || tableFromGravitino == null) {
            LOG.warn("Cannot update columns for table when altering because table or table entity is null");
            return Pair.of((Object)false, Collections.emptyList());
        }
        Map columnsFromCatalogTable = tableFromCatalog.columns() == null ? Collections.emptyMap() : IntStream.range(0, tableFromCatalog.columns().length).mapToObj(i -> Pair.of((Object)i, (Object)tableFromCatalog.columns()[i])).collect(Collectors.toMap(p -> ((Column)p.getRight()).name(), Function.identity()));
        Map columnsFromTableEntity = tableFromGravitino.columns() == null ? Collections.emptyMap() : tableFromGravitino.columns().stream().collect(Collectors.toMap(ColumnEntity::name, Function.identity()));
        ArrayList columnsToInsert = Lists.newArrayList();
        boolean columnsNeedsUpdate = false;
        for (Map.Entry entry : columnsFromTableEntity.entrySet()) {
            Pair columnPair = (Pair)columnsFromCatalogTable.get(entry.getKey());
            if (columnPair == null) {
                LOG.debug("Column {} is not found in the table from underlying source, it will be removed from the table entity", entry.getKey());
                columnsNeedsUpdate = true;
                continue;
            }
            if (!this.isSameColumn((Column)columnPair.getRight(), (Integer)columnPair.getLeft(), (ColumnEntity)entry.getValue())) {
                LOG.debug("Column {} is found in the table from underlying source, but it is different from the one in the table entity, it will be updated", entry.getKey());
                Column column = (Column)columnPair.getRight();
                ColumnEntity updatedColumnEntity = ColumnEntity.builder().withId(((ColumnEntity)entry.getValue()).id()).withName(column.name()).withPosition((Integer)columnPair.getLeft()).withDataType(column.dataType()).withComment(column.comment()).withNullable(column.nullable()).withAutoIncrement(column.autoIncrement()).withDefaultValue(column.defaultValue()).withAuditInfo(AuditInfo.builder().withCreator(((ColumnEntity)entry.getValue()).auditInfo().creator()).withCreateTime(((ColumnEntity)entry.getValue()).auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build()).build();
                columnsNeedsUpdate = true;
                columnsToInsert.add(updatedColumnEntity);
                continue;
            }
            columnsToInsert.add((ColumnEntity)entry.getValue());
        }
        for (Map.Entry entry : columnsFromCatalogTable.entrySet()) {
            if (columnsFromTableEntity.containsKey(entry.getKey())) continue;
            LOG.debug("Column {} is found in the table from underlying source but not in the table entity, it will be added to the table entity", entry.getKey());
            ColumnEntity newColumnEntity = ColumnEntity.toColumnEntity((Column)((Pair)entry.getValue()).getRight(), (Integer)((Pair)entry.getValue()).getLeft(), this.idGenerator.nextId(), AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build());
            columnsNeedsUpdate = true;
            columnsToInsert.add(newColumnEntity);
        }
        return Pair.of((Object)columnsNeedsUpdate, (Object)columnsToInsert);
    }

    private TableEntity updateColumnsIfNecessaryWhenLoad(NameIdentifier tableIdent, EntityCombinedTable combinedTable) {
        Pair<Boolean, List<ColumnEntity>> columnsUpdateResult = this.updateColumnsIfNecessary(combinedTable.tableFromCatalog(), combinedTable.tableFromGravitino());
        if (!((Boolean)columnsUpdateResult.getLeft()).booleanValue()) {
            return combinedTable.tableFromGravitino();
        }
        return TreeLockUtils.doWithTreeLock(tableIdent, LockType.WRITE, () -> this.operateOnEntity(tableIdent, id -> this.store.update((NameIdentifier)id, TableEntity.class, Entity.EntityType.TABLE, entity -> TableEntity.builder().withId(entity.id()).withName(entity.name()).withNamespace(entity.namespace()).withColumns((List)columnsUpdateResult.getRight()).withAuditInfo(AuditInfo.builder().withCreator(entity.auditInfo().creator()).withCreateTime(entity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build()).build()), "UPDATE", combinedTable.tableFromGravitino().id()));
    }
}

