/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.tag.Tag;

public class TagEntity
implements Tag,
Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, "The unique id of the tag entity.");
    public static final Field NAME = Field.required("name", String.class, "The name of the tag entity.");
    public static final Field COMMENT = Field.optional("comment", String.class, "The comment of the tag entity.");
    public static final Field PROPERTIES = Field.optional("properties", Map.class, "The properties of the tag entity.");
    public static final Field AUDIT_INFO = Field.required("audit_info", Audit.class, "The audit details of the tag entity.");
    private Long id;
    private String name;
    private Namespace namespace;
    private String comment;
    private Map<String, String> properties;
    private Audit auditInfo;

    private TagEntity() {
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(COMMENT, this.comment);
        fields.put(PROPERTIES, this.properties);
        fields.put(AUDIT_INFO, this.auditInfo);
        return Collections.unmodifiableMap(fields);
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.TAG;
    }

    @Override
    public Long id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    public String comment() {
        return this.comment;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Optional<Boolean> inherited() {
        return Optional.empty();
    }

    public Audit auditInfo() {
        return this.auditInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TagEntity)) {
            return false;
        }
        TagEntity that = (TagEntity)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.comment, that.comment) && Objects.equals(this.properties, that.properties) && Objects.equals(this.auditInfo, that.auditInfo);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.namespace, this.comment, this.properties, this.auditInfo);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final TagEntity tagEntity = new TagEntity();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.tagEntity.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.tagEntity.name = name;
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.tagEntity.namespace = namespace;
            return this;
        }

        public Builder withComment(String comment) {
            this.tagEntity.comment = comment;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.tagEntity.properties = properties;
            return this;
        }

        public Builder withAuditInfo(Audit auditInfo) {
            this.tagEntity.auditInfo = auditInfo;
            return this;
        }

        public TagEntity build() {
            this.tagEntity.validate();
            return this.tagEntity;
        }
    }
}

