/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.AuthorizationMetadataObject;

public class RangerHadoopSQLMetadataObject
implements AuthorizationMetadataObject {
    private final String name;
    private final String parent;
    private final AuthorizationMetadataObject.Type type;

    public RangerHadoopSQLMetadataObject(String parent, String name, AuthorizationMetadataObject.Type type) {
        this.parent = parent;
        this.name = name;
        this.type = type;
    }

    public String name() {
        return this.name;
    }

    public List<String> names() {
        return DOT_SPLITTER.splitToList((CharSequence)this.fullName());
    }

    public String parent() {
        return this.parent;
    }

    public AuthorizationMetadataObject.Type type() {
        return this.type;
    }

    public void validateAuthorizationMetadataObject() throws IllegalArgumentException {
        List<String> names = this.names();
        Preconditions.checkArgument((names != null && !names.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create a Ranger metadata object with no names");
        Preconditions.checkArgument((names.size() <= 3 ? 1 : 0) != 0, (Object)"Cannot create a Ranger metadata object with the name length which is greater than 3");
        Preconditions.checkArgument((this.type != null ? 1 : 0) != 0, (Object)"Cannot create a Ranger metadata object with no type");
        Preconditions.checkArgument((names.size() != 1 || this.type == Type.SCHEMA ? 1 : 0) != 0, (Object)"If the length of names is 1, it must be the SCHEMA type");
        Preconditions.checkArgument((names.size() != 2 || this.type == Type.TABLE ? 1 : 0) != 0, (Object)"If the length of names is 2, it must be the TABLE type");
        Preconditions.checkArgument((names.size() != 3 || this.type == Type.COLUMN ? 1 : 0) != 0, (Object)"If the length of names is 3, it must be COLUMN");
        for (String name : names) {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Cannot create a metadata object with null name");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangerHadoopSQLMetadataObject)) {
            return false;
        }
        RangerHadoopSQLMetadataObject that = (RangerHadoopSQLMetadataObject)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.parent, that.parent) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parent, this.type);
    }

    public String toString() {
        return "MetadataObject: [fullName=" + this.fullName() + "], [type=" + String.valueOf(this.type) + "]";
    }

    public static enum Type implements AuthorizationMetadataObject.Type
    {
        SCHEMA(MetadataObject.Type.SCHEMA),
        TABLE(MetadataObject.Type.TABLE),
        COLUMN(MetadataObject.Type.COLUMN);

        private final MetadataObject.Type metadataType;

        private Type(MetadataObject.Type type) {
            this.metadataType = type;
        }

        public MetadataObject.Type metadataObjectType() {
            return this.metadataType;
        }

        public static Type fromMetadataType(MetadataObject.Type metadataType) {
            for (Type type : Type.values()) {
                if (type.metadataType != metadataType) continue;
                return type;
            }
            throw new IllegalArgumentException("No matching RangerHadoopSQLMetadataObject.Type for " + String.valueOf(metadataType));
        }
    }
}

