/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.zookeeper.server.ByteBufferOutputStream;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.server.quorum.LearnerInfo;
import org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import org.apache.zookeeper.server.quorum.Observer;
import org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.StateSummary;
import org.apache.zookeeper.server.quorum.ZabUtils;
import org.apache.zookeeper.server.util.ZxidUtils;
import org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.ErrorTxn;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Zab1_0Test {
    private static final Logger LOG = LoggerFactory.getLogger(Zab1_0Test.class);
    private static final File testData = new File(System.getProperty("test.data.dir", "src/test/resources/data"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaderInConnectingFollowers() throws Exception {
        File tmpDir = File.createTempFile("test", "dir", testData);
        tmpDir.delete();
        tmpDir.mkdir();
        Leader leader = null;
        try {
            QuorumPeer peer = ZabUtils.createQuorumPeer(tmpDir);
            peer.leader = leader = ZabUtils.createLeader(tmpDir, peer);
            peer.setAcceptedEpoch(5L);
            FollowerMockThread f1 = new FollowerMockThread(1L, leader, true);
            FollowerMockThread f2 = new FollowerMockThread(2L, leader, true);
            f1.start();
            f2.start();
            f1.join(leader.self.getInitLimit() * leader.self.getTickTime() + 5000);
            f2.join(leader.self.getInitLimit() * leader.self.getTickTime() + 5000);
            try {
                long epoch = leader.getEpochToPropose(leader.self.getId(), leader.self.getAcceptedEpoch());
                Assert.assertEquals((String)"leader got wrong epoch from getEpochToPropose", (long)6L, (long)epoch);
            }
            catch (Exception e) {
                Assert.fail((String)"leader timed out in getEpochToPropose");
            }
        }
        finally {
            if (leader != null) {
                leader.shutdown("end of test");
            }
            this.recursiveDelete(tmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastAcceptedEpoch() throws Exception {
        File tmpDir = File.createTempFile("test", "dir", testData);
        tmpDir.delete();
        tmpDir.mkdir();
        ZabUtils.MockLeader leader = null;
        Thread leadThread = null;
        try {
            QuorumPeer peer = ZabUtils.createQuorumPeer(tmpDir);
            leader = ZabUtils.createMockLeader(tmpDir, peer);
            peer.leader = leader;
            peer.setAcceptedEpoch(5L);
            leadThread = new LeadThread(leader);
            leadThread.start();
            while (leader.getCurrentEpochToPropose() != 6L) {
                Thread.sleep(20L);
            }
            try {
                long epoch = leader.getEpochToPropose(1L, 6L);
                Assert.assertEquals((String)"New proposed epoch is wrong", (long)7L, (long)epoch);
            }
            catch (Exception e) {
                Assert.fail((String)"Timed out in getEpochToPropose");
            }
        }
        finally {
            if (leader != null) {
                leader.shutdown("end of test");
            }
            if (leadThread != null) {
                leadThread.interrupt();
                leadThread.join();
            }
            this.recursiveDelete(tmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaderInElectingFollowers() throws Exception {
        File tmpDir = File.createTempFile("test", "dir", testData);
        tmpDir.delete();
        tmpDir.mkdir();
        Leader leader = null;
        try {
            QuorumPeer peer = ZabUtils.createQuorumPeer(tmpDir);
            peer.leader = leader = ZabUtils.createLeader(tmpDir, peer);
            FollowerMockThread f1 = new FollowerMockThread(1L, leader, false);
            FollowerMockThread f2 = new FollowerMockThread(2L, leader, false);
            leader.readyToStart = true;
            leader.leaderStateSummary = new StateSummary(leader.self.getCurrentEpoch(), leader.zk.getLastProcessedZxid());
            f1.start();
            f2.start();
            f1.join(leader.self.getInitLimit() * leader.self.getTickTime() + 5000);
            f2.join(leader.self.getInitLimit() * leader.self.getTickTime() + 5000);
            Assert.assertTrue((String)(f1.msg + " without waiting for leader"), (f1.msg == null ? 1 : 0) != 0);
            Assert.assertTrue((String)(f2.msg + " without waiting for leader"), (f2.msg == null ? 1 : 0) != 0);
        }
        finally {
            if (leader != null) {
                leader.shutdown("end of test");
            }
            this.recursiveDelete(tmpDir);
        }
    }

    static Socket[] getSocketPair() throws IOException {
        ServerSocket ss = new ServerSocket();
        ss.bind(null);
        InetSocketAddress endPoint = (InetSocketAddress)ss.getLocalSocketAddress();
        Socket s = new Socket(endPoint.getAddress(), endPoint.getPort());
        return new Socket[]{s, ss.accept()};
    }

    static void readPacketSkippingPing(InputArchive ia, QuorumPacket qp) throws IOException {
        do {
            ia.readRecord((Record)qp, null);
        } while (qp.getType() == 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLeaderConversation(LeaderConversation conversation) throws Exception {
        Socket[] pair = Zab1_0Test.getSocketPair();
        Socket leaderSocket = pair[0];
        Socket followerSocket = pair[1];
        File tmpDir = File.createTempFile("test", "dir", testData);
        tmpDir.delete();
        tmpDir.mkdir();
        Thread leadThread = null;
        Leader leader = null;
        try {
            QuorumPeer peer = ZabUtils.createQuorumPeer(tmpDir);
            peer.leader = leader = ZabUtils.createLeader(tmpDir, peer);
            leadThread = new LeadThread(leader);
            leadThread.start();
            while (!leader.readyToStart) {
                Thread.sleep(20L);
            }
            LearnerHandler lh = new LearnerHandler(leaderSocket, new BufferedInputStream(leaderSocket.getInputStream()), leader);
            lh.start();
            leaderSocket.setSoTimeout(4000);
            BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)followerSocket.getInputStream());
            BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)followerSocket.getOutputStream());
            conversation.converseWithLeader((InputArchive)ia, (OutputArchive)oa, leader);
        }
        finally {
            if (leader != null) {
                leader.shutdown("end of test");
            }
            if (leadThread != null) {
                leadThread.interrupt();
                leadThread.join();
            }
            this.recursiveDelete(tmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPopulatedLeaderConversation(PopulatedLeaderConversation conversation, int ops) throws Exception {
        Socket[] pair = Zab1_0Test.getSocketPair();
        Socket leaderSocket = pair[0];
        Socket followerSocket = pair[1];
        File tmpDir = File.createTempFile("test", "dir", testData);
        tmpDir.delete();
        tmpDir.mkdir();
        Thread leadThread = null;
        Leader leader = null;
        try {
            FileTxnSnapLog snapLog = new FileTxnSnapLog(tmpDir, tmpDir);
            ZKDatabase zkDb = new ZKDatabase(snapLog);
            Assert.assertTrue((ops >= 1 ? 1 : 0) != 0);
            long zxid = ZxidUtils.makeZxid((long)1L, (long)0L);
            for (int i = 1; i <= ops; ++i) {
                zxid = ZxidUtils.makeZxid((long)1L, (long)i);
                String path = "/foo-" + i;
                zkDb.processTxn(new TxnHeader(13L, 1000 + i, zxid, (long)(30 + i), 1), (Record)new CreateTxn(path, "fpjwasalsohere".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 1));
                Stat stat = new Stat();
                Assert.assertEquals((Object)"fpjwasalsohere", (Object)new String(zkDb.getData(path, stat, null)));
            }
            Assert.assertTrue((zxid > ZxidUtils.makeZxid((long)1L, (long)0L) ? 1 : 0) != 0);
            snapLog.save(zkDb.getDataTree(), zkDb.getSessionWithTimeOuts());
            snapLog.close();
            QuorumPeer peer = ZabUtils.createQuorumPeer(tmpDir);
            peer.leader = leader = ZabUtils.createLeader(tmpDir, peer);
            peer.setAcceptedEpoch(1L);
            peer.setCurrentEpoch(1L);
            leadThread = new LeadThread(leader);
            leadThread.start();
            while (leader.cnxAcceptor == null || !leader.cnxAcceptor.isAlive()) {
                Thread.sleep(20L);
            }
            LearnerHandler lh = new LearnerHandler(leaderSocket, new BufferedInputStream(leaderSocket.getInputStream()), leader);
            lh.start();
            leaderSocket.setSoTimeout(4000);
            BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)followerSocket.getInputStream());
            BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)followerSocket.getOutputStream());
            conversation.converseWithLeader((InputArchive)ia, (OutputArchive)oa, leader, zxid);
        }
        finally {
            if (leader != null) {
                leader.shutdown("end of test");
            }
            if (leadThread != null) {
                leadThread.interrupt();
                leadThread.join();
            }
            this.recursiveDelete(tmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFollowerConversation(FollowerConversation conversation) throws Exception {
        File tmpDir = File.createTempFile("test", "dir", testData);
        tmpDir.delete();
        tmpDir.mkdir();
        Thread followerThread = null;
        ConversableFollower follower = null;
        QuorumPeer peer = null;
        try {
            peer = ZabUtils.createQuorumPeer(tmpDir);
            follower = this.createFollower(tmpDir, peer);
            peer.follower = follower;
            ServerSocket ss = new ServerSocket();
            ss.bind(null);
            QuorumPeer.QuorumServer leaderQS = new QuorumPeer.QuorumServer(1L, (InetSocketAddress)ss.getLocalSocketAddress());
            follower.setLeaderQuorumServer(leaderQS);
            final ConversableFollower followerForThread = follower;
            followerThread = new Thread(){

                @Override
                public void run() {
                    try {
                        followerForThread.followLeader();
                    }
                    catch (InterruptedException e) {
                        LOG.info("Follower thread interrupted", (Throwable)e);
                    }
                    catch (Exception e) {
                        LOG.warn("Unexpected exception in follower thread", (Throwable)e);
                    }
                }
            };
            followerThread.start();
            Socket leaderSocket = ss.accept();
            BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)leaderSocket.getInputStream());
            BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)leaderSocket.getOutputStream());
            conversation.converseWithFollower((InputArchive)ia, (OutputArchive)oa, follower);
        }
        finally {
            if (follower != null) {
                follower.shutdown();
            }
            if (followerThread != null) {
                followerThread.interrupt();
                followerThread.join();
            }
            if (peer != null) {
                peer.shutdown();
            }
            this.recursiveDelete(tmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testObserverConversation(ObserverConversation conversation) throws Exception {
        File tmpDir = File.createTempFile("test", "dir", testData);
        tmpDir.delete();
        tmpDir.mkdir();
        Thread observerThread = null;
        ConversableObserver observer = null;
        QuorumPeer peer = null;
        try {
            peer = ZabUtils.createQuorumPeer(tmpDir);
            peer.setSyncEnabled(true);
            observer = this.createObserver(tmpDir, peer);
            peer.observer = observer;
            ServerSocket ss = new ServerSocket();
            ss.bind(null);
            QuorumPeer.QuorumServer leaderQS = new QuorumPeer.QuorumServer(1L, (InetSocketAddress)ss.getLocalSocketAddress());
            observer.setLeaderQuorumServer(leaderQS);
            final ConversableObserver observerForThread = observer;
            observerThread = new Thread(){

                @Override
                public void run() {
                    try {
                        observerForThread.observeLeader();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            observerThread.start();
            Socket leaderSocket = ss.accept();
            BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)leaderSocket.getInputStream());
            BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)leaderSocket.getOutputStream());
            conversation.converseWithObserver((InputArchive)ia, (OutputArchive)oa, observer);
        }
        finally {
            if (observer != null) {
                observer.shutdown();
            }
            if (observerThread != null) {
                observerThread.interrupt();
                observerThread.join();
            }
            if (peer != null) {
                peer.shutdown();
            }
            this.recursiveDelete(tmpDir);
        }
    }

    @Test
    public void testUnnecessarySnap() throws Exception {
        this.testPopulatedLeaderConversation(new PopulatedLeaderConversation(){

            @Override
            public void converseWithLeader(InputArchive ia, OutputArchive oa, Leader l, long zxid) throws Exception {
                Assert.assertEquals((long)1L, (long)l.self.getAcceptedEpoch());
                Assert.assertEquals((long)1L, (long)l.self.getCurrentEpoch());
                LearnerInfo li = new LearnerInfo(1L, 65536);
                byte[] liBytes = new byte[12];
                ByteBufferOutputStream.record2ByteBuffer((Record)li, (ByteBuffer)ByteBuffer.wrap(liBytes));
                QuorumPacket qp = new QuorumPacket(11, 1L, liBytes, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)17L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)2L, (long)0L), (long)qp.getZxid());
                Assert.assertEquals((long)ByteBuffer.wrap(qp.getData()).getInt(), (long)65536L);
                Assert.assertEquals((long)2L, (long)l.self.getAcceptedEpoch());
                Assert.assertEquals((long)1L, (long)l.self.getCurrentEpoch());
                byte[] epochBytes = new byte[4];
                ByteBuffer wrappedEpochBytes = ByteBuffer.wrap(epochBytes);
                wrappedEpochBytes.putInt(1);
                qp = new QuorumPacket(18, zxid, epochBytes, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)13L, (long)qp.getType());
            }
        }, 2);
    }

    @Test
    public void testNormalFollowerRun() throws Exception {
        this.testFollowerConversation(new FollowerConversation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void converseWithFollower(InputArchive ia, OutputArchive oa, Follower f) throws Exception {
                File tmpDir = File.createTempFile("test", "dir", testData);
                tmpDir.delete();
                tmpDir.mkdir();
                File logDir = f.fzk.getTxnLogFactory().getDataDir().getParentFile();
                File snapDir = f.fzk.getTxnLogFactory().getSnapDir().getParentFile();
                f.zk = (LearnerZooKeeperServer)Mockito.spy((Object)f.zk);
                try {
                    Assert.assertEquals((long)0L, (long)f.self.getAcceptedEpoch());
                    Assert.assertEquals((long)0L, (long)f.self.getCurrentEpoch());
                    ZKDatabase zkDb = new ZKDatabase(new FileTxnSnapLog(tmpDir, tmpDir));
                    long firstZxid = ZxidUtils.makeZxid((long)1L, (long)1L);
                    zkDb.processTxn(new TxnHeader(13L, 1313, firstZxid, 33L, 1), (Record)new CreateTxn("/foo", "data1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 1));
                    Stat stat = new Stat();
                    Assert.assertEquals((Object)"data1", (Object)new String(zkDb.getData("/foo", stat, null)));
                    QuorumPacket qp = new QuorumPacket();
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)11L, (long)qp.getType());
                    Assert.assertEquals((long)qp.getZxid(), (long)0L);
                    LearnerInfo learnInfo = new LearnerInfo();
                    ByteBufferInputStream.byteBuffer2Record((ByteBuffer)ByteBuffer.wrap(qp.getData()), (Record)learnInfo);
                    Assert.assertEquals((long)learnInfo.getProtocolVersion(), (long)65536L);
                    Assert.assertEquals((long)learnInfo.getServerid(), (long)0L);
                    qp.setType(17);
                    qp.setZxid(ZxidUtils.makeZxid((long)1L, (long)0L));
                    byte[] protoBytes = new byte[4];
                    ByteBuffer.wrap(protoBytes).putInt(65536);
                    qp.setData(protoBytes);
                    oa.writeRecord((Record)qp, null);
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)18L, (long)qp.getType());
                    Assert.assertEquals((long)0L, (long)qp.getZxid());
                    Assert.assertEquals((long)ZxidUtils.makeZxid((long)0L, (long)0L), (long)ByteBuffer.wrap(qp.getData()).getInt());
                    Assert.assertEquals((long)1L, (long)f.self.getAcceptedEpoch());
                    Assert.assertEquals((long)0L, (long)f.self.getCurrentEpoch());
                    qp.setType(15);
                    qp.setData(new byte[0]);
                    qp.setZxid(zkDb.getDataTreeLastProcessedZxid());
                    oa.writeRecord((Record)qp, null);
                    zkDb.serializeSnapshot(oa);
                    oa.writeString("BenWasHere", null);
                    Thread.sleep(10L);
                    ((LearnerZooKeeperServer)Mockito.verify((Object)f.zk, (VerificationMode)Mockito.never())).takeSnapshot();
                    qp.setType(10);
                    qp.setZxid(ZxidUtils.makeZxid((long)1L, (long)0L));
                    oa.writeRecord((Record)qp, null);
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)3L, (long)qp.getType());
                    Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                    Assert.assertEquals((long)1L, (long)f.self.getAcceptedEpoch());
                    Assert.assertEquals((long)1L, (long)f.self.getCurrentEpoch());
                    ((LearnerZooKeeperServer)Mockito.verify((Object)f.zk)).takeSnapshot();
                    Assert.assertEquals((long)firstZxid, (long)f.fzk.getLastProcessedZxid());
                    ZKDatabase zkDb2 = new ZKDatabase(new FileTxnSnapLog(logDir, snapDir));
                    long lastZxid = zkDb2.loadDataBase();
                    Assert.assertEquals((Object)"data1", (Object)new String(zkDb2.getData("/foo", stat, null)));
                    Assert.assertEquals((long)firstZxid, (long)lastZxid);
                    long proposalZxid = ZxidUtils.makeZxid((long)1L, (long)1000L);
                    this.proposeSetData(qp, proposalZxid, "data2", 2);
                    oa.writeRecord((Record)qp, null);
                    TrackerWatcher watcher = new TrackerWatcher();
                    Assert.assertEquals((Object)"data1", (Object)new String(f.fzk.getZKDatabase().getData("/foo", stat, (Watcher)watcher)));
                    qp.setType(4);
                    qp.setZxid(proposalZxid);
                    oa.writeRecord((Record)qp, null);
                    qp.setType(12);
                    qp.setZxid(0L);
                    oa.writeRecord((Record)qp, null);
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)3L, (long)qp.getType());
                    Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)3L, (long)qp.getType());
                    Assert.assertEquals((long)proposalZxid, (long)qp.getZxid());
                    watcher.waitForChange();
                    Assert.assertEquals((Object)"data2", (Object)new String(f.fzk.getZKDatabase().getData("/foo", stat, null)));
                    zkDb2 = new ZKDatabase(new FileTxnSnapLog(logDir, snapDir));
                    lastZxid = zkDb2.loadDataBase();
                    Assert.assertEquals((Object)"data2", (Object)new String(zkDb2.getData("/foo", stat, null)));
                    Assert.assertEquals((long)proposalZxid, (long)lastZxid);
                }
                finally {
                    Zab1_0Test.this.recursiveDelete(tmpDir);
                }
            }

            private void proposeSetData(QuorumPacket qp, long zxid, String data, int version) throws IOException {
                qp.setType(2);
                qp.setZxid(zxid);
                TxnHeader hdr = new TxnHeader(4L, 1414, qp.getZxid(), 55L, 5);
                SetDataTxn sdt = new SetDataTxn("/foo", data.getBytes(), version);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
                boa.writeRecord((Record)hdr, null);
                boa.writeRecord((Record)sdt, null);
                qp.setData(baos.toByteArray());
            }
        });
    }

    @Test
    public void testNormalFollowerRunWithDiff() throws Exception {
        this.testFollowerConversation(new FollowerConversation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void converseWithFollower(InputArchive ia, OutputArchive oa, Follower f) throws Exception {
                File tmpDir = File.createTempFile("test", "dir", testData);
                tmpDir.delete();
                tmpDir.mkdir();
                File logDir = f.fzk.getTxnLogFactory().getDataDir().getParentFile();
                File snapDir = f.fzk.getTxnLogFactory().getSnapDir().getParentFile();
                f.zk = (LearnerZooKeeperServer)Mockito.spy((Object)f.zk);
                try {
                    Assert.assertEquals((long)0L, (long)f.self.getAcceptedEpoch());
                    Assert.assertEquals((long)0L, (long)f.self.getCurrentEpoch());
                    ZKDatabase zkDb = new ZKDatabase(new FileTxnSnapLog(tmpDir, tmpDir));
                    long firstZxid = ZxidUtils.makeZxid((long)1L, (long)1L);
                    zkDb.processTxn(new TxnHeader(13L, 1313, firstZxid, 33L, 1), (Record)new CreateTxn("/foo", "data1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 1));
                    Stat stat = new Stat();
                    Assert.assertEquals((Object)"data1", (Object)new String(zkDb.getData("/foo", stat, null)));
                    QuorumPacket qp = new QuorumPacket();
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)11L, (long)qp.getType());
                    Assert.assertEquals((long)qp.getZxid(), (long)0L);
                    LearnerInfo learnInfo = new LearnerInfo();
                    ByteBufferInputStream.byteBuffer2Record((ByteBuffer)ByteBuffer.wrap(qp.getData()), (Record)learnInfo);
                    Assert.assertEquals((long)learnInfo.getProtocolVersion(), (long)65536L);
                    Assert.assertEquals((long)learnInfo.getServerid(), (long)0L);
                    qp.setType(17);
                    qp.setZxid(ZxidUtils.makeZxid((long)1L, (long)0L));
                    byte[] protoBytes = new byte[4];
                    ByteBuffer.wrap(protoBytes).putInt(65536);
                    qp.setData(protoBytes);
                    oa.writeRecord((Record)qp, null);
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)18L, (long)qp.getType());
                    Assert.assertEquals((long)0L, (long)qp.getZxid());
                    Assert.assertEquals((long)ZxidUtils.makeZxid((long)0L, (long)0L), (long)ByteBuffer.wrap(qp.getData()).getInt());
                    Assert.assertEquals((long)1L, (long)f.self.getAcceptedEpoch());
                    Assert.assertEquals((long)0L, (long)f.self.getCurrentEpoch());
                    qp.setType(13);
                    qp.setData(new byte[0]);
                    qp.setZxid(zkDb.getDataTreeLastProcessedZxid());
                    oa.writeRecord((Record)qp, null);
                    long createSessionZxid = ZxidUtils.makeZxid((long)1L, (long)2L);
                    this.proposeNewSession(qp, createSessionZxid, 819L);
                    oa.writeRecord((Record)qp, null);
                    qp.setType(4);
                    qp.setZxid(createSessionZxid);
                    oa.writeRecord((Record)qp, null);
                    qp.setType(10);
                    qp.setZxid(ZxidUtils.makeZxid((long)1L, (long)0L));
                    oa.writeRecord((Record)qp, null);
                    qp.setType(12);
                    qp.setZxid(0L);
                    oa.writeRecord((Record)qp, null);
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)3L, (long)qp.getType());
                    Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)3L, (long)qp.getType());
                    Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                    Assert.assertEquals((long)1L, (long)f.self.getAcceptedEpoch());
                    Assert.assertEquals((long)1L, (long)f.self.getCurrentEpoch());
                    long start = System.currentTimeMillis();
                    while (createSessionZxid != f.fzk.getLastProcessedZxid() && System.currentTimeMillis() - start < 50L) {
                        Thread.sleep(1L);
                    }
                    Assert.assertEquals((long)createSessionZxid, (long)f.fzk.getLastProcessedZxid());
                    ZKDatabase zkDb2 = new ZKDatabase(new FileTxnSnapLog(logDir, snapDir));
                    start = System.currentTimeMillis();
                    zkDb2.loadDataBase();
                    while (zkDb2.getSessionWithTimeOuts().isEmpty() && System.currentTimeMillis() - start < 50L) {
                        Thread.sleep(1L);
                        zkDb2.loadDataBase();
                    }
                    LOG.info("zkdb2 sessions:" + zkDb2.getSessions());
                    LOG.info("zkdb2 with timeouts:" + zkDb2.getSessionWithTimeOuts());
                    Assert.assertNotNull(zkDb2.getSessionWithTimeOuts().get(4L));
                    ((LearnerZooKeeperServer)Mockito.verify((Object)f.zk, (VerificationMode)Mockito.never())).takeSnapshot();
                }
                finally {
                    Zab1_0Test.this.recursiveDelete(tmpDir);
                }
            }

            private void proposeNewSession(QuorumPacket qp, long zxid, long sessionId) throws IOException {
                qp.setType(2);
                qp.setZxid(zxid);
                TxnHeader hdr = new TxnHeader(4L, 1414, qp.getZxid(), 55L, -10);
                CreateSessionTxn cst = new CreateSessionTxn(30000);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
                boa.writeRecord((Record)hdr, null);
                boa.writeRecord((Record)cst, null);
                qp.setData(baos.toByteArray());
            }
        });
    }

    @Test
    public void testNormalRun() throws Exception {
        this.testLeaderConversation(new LeaderConversation(){

            @Override
            public void converseWithLeader(InputArchive ia, OutputArchive oa, Leader l) throws IOException {
                Assert.assertEquals((long)0L, (long)l.self.getAcceptedEpoch());
                Assert.assertEquals((long)0L, (long)l.self.getCurrentEpoch());
                LearnerInfo li = new LearnerInfo(1L, 65536);
                byte[] liBytes = new byte[12];
                ByteBufferOutputStream.record2ByteBuffer((Record)li, (ByteBuffer)ByteBuffer.wrap(liBytes));
                QuorumPacket qp = new QuorumPacket(11, 0L, liBytes, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)17L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                Assert.assertEquals((long)ByteBuffer.wrap(qp.getData()).getInt(), (long)65536L);
                Assert.assertEquals((long)1L, (long)l.self.getAcceptedEpoch());
                Assert.assertEquals((long)0L, (long)l.self.getCurrentEpoch());
                qp = new QuorumPacket(18, 0L, new byte[4], null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)13L, (long)qp.getType());
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)10L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                Assert.assertEquals((long)1L, (long)l.self.getAcceptedEpoch());
                Assert.assertEquals((long)1L, (long)l.self.getCurrentEpoch());
                qp = new QuorumPacket(3, qp.getZxid(), null, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)12L, (long)qp.getType());
            }
        });
    }

    @Test
    public void testTxnTimeout() throws Exception {
        this.testLeaderConversation(new LeaderConversation(){

            @Override
            public void converseWithLeader(InputArchive ia, OutputArchive oa, Leader l) throws IOException, InterruptedException, Leader.XidRolloverException {
                Assert.assertEquals((long)0L, (long)l.self.getAcceptedEpoch());
                Assert.assertEquals((long)0L, (long)l.self.getCurrentEpoch());
                LearnerInfo li = new LearnerInfo(1L, 65536);
                byte[] liBytes = new byte[20];
                ByteBufferOutputStream.record2ByteBuffer((Record)li, (ByteBuffer)ByteBuffer.wrap(liBytes));
                QuorumPacket qp = new QuorumPacket(11, 0L, liBytes, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)17L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                Assert.assertEquals((long)ByteBuffer.wrap(qp.getData()).getInt(), (long)65536L);
                Assert.assertEquals((long)1L, (long)l.self.getAcceptedEpoch());
                Assert.assertEquals((long)0L, (long)l.self.getCurrentEpoch());
                qp = new QuorumPacket(18, 0L, new byte[4], null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)13L, (long)qp.getType());
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)10L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                Assert.assertEquals((long)1L, (long)l.self.getAcceptedEpoch());
                Assert.assertEquals((long)1L, (long)l.self.getCurrentEpoch());
                qp = new QuorumPacket(3, qp.getZxid(), null, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)12L, (long)qp.getType());
                l.propose(this.createNodeRequest(l.zk.getZxid()));
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)2L, (long)qp.getType());
                LOG.info("Proposal sent.");
                for (int i = 0; i < 6; ++i) {
                    try {
                        ia.readRecord((Record)qp, null);
                        LOG.info("Ping received: " + i);
                        qp = new QuorumPacket(5, qp.getZxid(), "".getBytes(), null);
                        oa.writeRecord((Record)qp, null);
                        continue;
                    }
                    catch (EOFException e) {
                        return;
                    }
                }
                Assert.fail((String)"Connection hasn't been closed by leader after transaction times out.");
            }

            private Request createNodeRequest(long zxid) throws IOException {
                TxnHeader hdr = new TxnHeader(1L, 1, zxid, 1L, 1);
                CreateTxn ct = new CreateTxn("/foo", "data".getBytes(), null, true, 0);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
                boa.writeRecord((Record)hdr, "header");
                boa.writeRecord((Record)ct, "txn");
                baos.close();
                Request rq = new Request(null, 1L, 1, 1, ByteBuffer.wrap(baos.toByteArray()), null);
                rq.zxid = zxid;
                rq.hdr = hdr;
                rq.txn = ct;
                return rq;
            }
        });
    }

    private void deserializeSnapshot(InputArchive ia) throws IOException {
        ZKDatabase zkdb = new ZKDatabase(null);
        zkdb.deserializeSnapshot(ia);
        String signature = ia.readString("signature");
        Assert.assertEquals((Object)"BenWasHere", (Object)signature);
    }

    @Test
    public void testNormalObserverRun() throws Exception {
        this.testObserverConversation(new ObserverConversation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void converseWithObserver(InputArchive ia, OutputArchive oa, Observer o) throws Exception {
                File tmpDir = File.createTempFile("test", "dir", testData);
                tmpDir.delete();
                tmpDir.mkdir();
                File logDir = o.zk.getTxnLogFactory().getDataDir().getParentFile();
                File snapDir = o.zk.getTxnLogFactory().getSnapDir().getParentFile();
                try {
                    Assert.assertEquals((long)0L, (long)o.self.getAcceptedEpoch());
                    Assert.assertEquals((long)0L, (long)o.self.getCurrentEpoch());
                    ZKDatabase zkDb = new ZKDatabase(new FileTxnSnapLog(tmpDir, tmpDir));
                    long foo1Zxid = ZxidUtils.makeZxid((long)1L, (long)1L);
                    long foo2Zxid = ZxidUtils.makeZxid((long)1L, (long)2L);
                    zkDb.processTxn(new TxnHeader(13L, 1313, foo1Zxid, 33L, 1), (Record)new CreateTxn("/foo1", "data1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 1));
                    zkDb.processTxn(new TxnHeader(13L, 1313, foo2Zxid, 33L, 1), (Record)new CreateTxn("/foo2", "data1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 1));
                    Stat stat = new Stat();
                    Assert.assertEquals((Object)"data1", (Object)new String(zkDb.getData("/foo1", stat, null)));
                    Assert.assertEquals((Object)"data1", (Object)new String(zkDb.getData("/foo2", stat, null)));
                    QuorumPacket qp = new QuorumPacket();
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)16L, (long)qp.getType());
                    Assert.assertEquals((long)qp.getZxid(), (long)0L);
                    LearnerInfo learnInfo = new LearnerInfo();
                    ByteBufferInputStream.byteBuffer2Record((ByteBuffer)ByteBuffer.wrap(qp.getData()), (Record)learnInfo);
                    Assert.assertEquals((long)learnInfo.getProtocolVersion(), (long)65536L);
                    Assert.assertEquals((long)learnInfo.getServerid(), (long)0L);
                    qp.setType(17);
                    qp.setZxid(ZxidUtils.makeZxid((long)1L, (long)0L));
                    byte[] protoBytes = new byte[4];
                    ByteBuffer.wrap(protoBytes).putInt(65536);
                    qp.setData(protoBytes);
                    oa.writeRecord((Record)qp, null);
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)18L, (long)qp.getType());
                    Assert.assertEquals((long)0L, (long)qp.getZxid());
                    Assert.assertEquals((long)ZxidUtils.makeZxid((long)0L, (long)0L), (long)ByteBuffer.wrap(qp.getData()).getInt());
                    Assert.assertEquals((long)1L, (long)o.self.getAcceptedEpoch());
                    Assert.assertEquals((long)0L, (long)o.self.getCurrentEpoch());
                    qp.setType(15);
                    qp.setData(new byte[0]);
                    qp.setZxid(zkDb.getDataTreeLastProcessedZxid());
                    oa.writeRecord((Record)qp, null);
                    zkDb.serializeSnapshot(oa);
                    oa.writeString("BenWasHere", null);
                    qp.setType(10);
                    qp.setZxid(ZxidUtils.makeZxid((long)1L, (long)0L));
                    oa.writeRecord((Record)qp, null);
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)3L, (long)qp.getType());
                    Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                    Assert.assertEquals((long)1L, (long)o.self.getAcceptedEpoch());
                    Assert.assertEquals((long)1L, (long)o.self.getCurrentEpoch());
                    Assert.assertEquals((long)foo2Zxid, (long)o.zk.getLastProcessedZxid());
                    ZKDatabase zkDb2 = new ZKDatabase(new FileTxnSnapLog(logDir, snapDir));
                    long lastZxid = zkDb2.loadDataBase();
                    Assert.assertEquals((Object)"data1", (Object)new String(zkDb2.getData("/foo1", stat, null)));
                    Assert.assertEquals((long)foo2Zxid, (long)lastZxid);
                    TrackerWatcher watcher = new TrackerWatcher();
                    Assert.assertEquals((Object)"data1", (Object)new String(o.zk.getZKDatabase().getData("/foo2", stat, (Watcher)watcher)));
                    long proposalZxid = ZxidUtils.makeZxid((long)1L, (long)1000L);
                    this.proposeSetData(qp, "/foo1", proposalZxid, "data2", 2);
                    oa.writeRecord((Record)qp, null);
                    qp.setType(4);
                    qp.setZxid(proposalZxid);
                    oa.writeRecord((Record)qp, null);
                    long informZxid = ZxidUtils.makeZxid((long)1L, (long)1001L);
                    this.proposeSetData(qp, "/foo2", informZxid, "data2", 2);
                    qp.setType(8);
                    oa.writeRecord((Record)qp, null);
                    qp.setType(12);
                    qp.setZxid(0L);
                    oa.writeRecord((Record)qp, null);
                    Zab1_0Test.readPacketSkippingPing(ia, qp);
                    Assert.assertEquals((long)3L, (long)qp.getType());
                    Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                    watcher.waitForChange();
                    Assert.assertEquals((Object)"data2", (Object)new String(o.zk.getZKDatabase().getData("/foo1", stat, null)));
                    Assert.assertEquals((Object)"data2", (Object)new String(o.zk.getZKDatabase().getData("/foo2", stat, null)));
                    o.zk.shutdown();
                    zkDb2 = new ZKDatabase(new FileTxnSnapLog(logDir, snapDir));
                    lastZxid = zkDb2.loadDataBase();
                    Assert.assertEquals((Object)"data2", (Object)new String(zkDb2.getData("/foo1", stat, null)));
                    Assert.assertEquals((Object)"data2", (Object)new String(zkDb2.getData("/foo2", stat, null)));
                    Assert.assertEquals((long)informZxid, (long)lastZxid);
                }
                finally {
                    Zab1_0Test.this.recursiveDelete(tmpDir);
                }
            }

            private void proposeSetData(QuorumPacket qp, String path, long zxid, String data, int version) throws IOException {
                qp.setType(2);
                qp.setZxid(zxid);
                TxnHeader hdr = new TxnHeader(4L, 1414, qp.getZxid(), 55L, 5);
                SetDataTxn sdt = new SetDataTxn(path, data.getBytes(), version);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
                boa.writeRecord((Record)hdr, null);
                boa.writeRecord((Record)sdt, null);
                qp.setData(baos.toByteArray());
            }
        });
    }

    @Test
    public void testLeaderBehind() throws Exception {
        this.testLeaderConversation(new LeaderConversation(){

            @Override
            public void converseWithLeader(InputArchive ia, OutputArchive oa, Leader l) throws IOException {
                LearnerInfo li = new LearnerInfo(1L, 65536);
                byte[] liBytes = new byte[12];
                ByteBufferOutputStream.record2ByteBuffer((Record)li, (ByteBuffer)ByteBuffer.wrap(liBytes));
                QuorumPacket qp = new QuorumPacket(11, ZxidUtils.makeZxid((long)20L, (long)0L), liBytes, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)17L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)21L, (long)0L), (long)qp.getZxid());
                Assert.assertEquals((long)ByteBuffer.wrap(qp.getData()).getInt(), (long)65536L);
                qp = new QuorumPacket(18, 0L, new byte[4], null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)13L, (long)qp.getType());
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)10L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)21L, (long)0L), (long)qp.getZxid());
                qp = new QuorumPacket(3, qp.getZxid(), null, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)12L, (long)qp.getType());
            }
        });
    }

    @Test
    public void testAbandonBeforeACKEpoch() throws Exception {
        this.testLeaderConversation(new LeaderConversation(){

            @Override
            public void converseWithLeader(InputArchive ia, OutputArchive oa, Leader l) throws IOException, InterruptedException {
                LearnerInfo li = new LearnerInfo(1L, 65536);
                byte[] liBytes = new byte[12];
                ByteBufferOutputStream.record2ByteBuffer((Record)li, (ByteBuffer)ByteBuffer.wrap(liBytes));
                QuorumPacket qp = new QuorumPacket(11, 0L, liBytes, null);
                oa.writeRecord((Record)qp, null);
                Zab1_0Test.readPacketSkippingPing(ia, qp);
                Assert.assertEquals((long)17L, (long)qp.getType());
                Assert.assertEquals((long)ZxidUtils.makeZxid((long)1L, (long)0L), (long)qp.getZxid());
                Assert.assertEquals((long)ByteBuffer.wrap(qp.getData()).getInt(), (long)65536L);
                Thread.sleep(l.self.getInitLimit() * l.self.getTickTime() + 5000);
                Assert.assertEquals((long)0L, (long)l.self.getCurrentEpoch());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirtySnapshot() throws IOException, InterruptedException, KeeperException, NoSuchFieldException, IllegalAccessException {
        Socket[] pair = Zab1_0Test.getSocketPair();
        Socket leaderSocket = pair[0];
        Socket followerSocket = pair[1];
        File tmpDir = File.createTempFile("test", "dir");
        tmpDir.delete();
        tmpDir.mkdir();
        Thread leadThread = null;
        Leader leader = null;
        try {
            FileTxnSnapLog snapLog = new FileTxnSnapLog(tmpDir, tmpDir);
            ZKDatabase zkDb = new ZKDatabase(snapLog);
            long zxid = ZxidUtils.makeZxid((long)0L, (long)1L);
            String path = "/foo";
            zkDb.processTxn(new TxnHeader(13L, 1000, zxid, 30L, 1), (Record)new CreateTxn(path, "fpjwasalsohere".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 1));
            Stat stat = new Stat();
            Assert.assertEquals((Object)"fpjwasalsohere", (Object)new String(zkDb.getData(path, stat, null)));
            snapLog.close();
            QuorumPeer peer = ZabUtils.createQuorumPeer(tmpDir);
            peer.leader = leader = ZabUtils.createLeader(tmpDir, peer);
            peer.setAcceptedEpoch(0L);
            peer.setCurrentEpoch(0L);
            leadThread = new LeadThread(leader);
            leadThread.start();
            while (leader.cnxAcceptor == null || !leader.cnxAcceptor.isAlive()) {
                Thread.sleep(20L);
            }
            leader.shutdown("Shutting down the leader");
            File snapDir = new File(tmpDir, "version-2");
            List files = Util.sortDataDir((File[])snapDir.listFiles(), (String)"snapshot", (boolean)false);
            for (File f : files) {
                try {
                    Assert.assertFalse((String)"Found a valid snapshot", (boolean)Util.isValidSnapshot((File)f));
                }
                catch (IOException e) {
                    LOG.info("invalid snapshot " + f, (Throwable)e);
                }
            }
        }
        finally {
            if (leader != null) {
                leader.shutdown("end of test");
            }
            if (leadThread != null) {
                leadThread.interrupt();
                leadThread.join();
            }
            this.recursiveDelete(tmpDir);
        }
    }

    private void recursiveDelete(File file) {
        if (file.isFile()) {
            file.delete();
        } else {
            File[] files = file.listFiles();
            if (files != null) {
                for (File c : files) {
                    this.recursiveDelete(c);
                }
            }
            file.delete();
        }
    }

    private ConversableFollower createFollower(File tmpDir, QuorumPeer peer) throws IOException {
        FileTxnSnapLog logFactory = new FileTxnSnapLog(tmpDir, tmpDir);
        peer.setTxnFactory(logFactory);
        ZKDatabase zkDb = new ZKDatabase(logFactory);
        FollowerZooKeeperServer zk = new FollowerZooKeeperServer(logFactory, peer, (ZooKeeperServer.DataTreeBuilder)new ZooKeeperServer.BasicDataTreeBuilder(), zkDb);
        peer.setZKDatabase(zkDb);
        return new ConversableFollower(peer, zk);
    }

    private ConversableObserver createObserver(File tmpDir, QuorumPeer peer) throws IOException {
        FileTxnSnapLog logFactory = new FileTxnSnapLog(tmpDir, tmpDir);
        peer.setTxnFactory(logFactory);
        ZooKeeperServer.BasicDataTreeBuilder treeBuilder = new ZooKeeperServer.BasicDataTreeBuilder();
        ZKDatabase zkDb = new ZKDatabase(logFactory);
        ObserverZooKeeperServer zk = new ObserverZooKeeperServer(logFactory, peer, (ZooKeeperServer.DataTreeBuilder)treeBuilder, zkDb);
        peer.setZKDatabase(zkDb);
        return new ConversableObserver(peer, zk);
    }

    private String readContentsOfFile(File f) throws IOException {
        return new BufferedReader(new FileReader(f)).readLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitialAcceptedCurrent() throws Exception {
        File tmpDir = File.createTempFile("test", ".dir", testData);
        tmpDir.delete();
        tmpDir.mkdir();
        try {
            FileTxnSnapLog logFactory = new FileTxnSnapLog(tmpDir, tmpDir);
            File version2 = new File(tmpDir, "version-2");
            version2.mkdir();
            long zxid = ZxidUtils.makeZxid((long)3L, (long)3L);
            TxnHeader hdr = new TxnHeader(1L, 1, zxid, 1L, -1);
            ErrorTxn txn = new ErrorTxn(1);
            byte[] buf = Util.marshallTxnEntry((TxnHeader)hdr, (Record)txn);
            Request req = new Request(null, 1L, 1, -1, ByteBuffer.wrap(buf), null);
            req.hdr = hdr;
            req.txn = txn;
            logFactory.append(req);
            logFactory.commit();
            ZKDatabase zkDb = new ZKDatabase(logFactory);
            QuorumPeer peer = QuorumPeer.testingQuorumPeer();
            peer.setZKDatabase(zkDb);
            peer.setTxnFactory(logFactory);
            peer.getLastLoggedZxid();
            Assert.assertEquals((long)3L, (long)peer.getAcceptedEpoch());
            Assert.assertEquals((long)3L, (long)peer.getCurrentEpoch());
            Assert.assertEquals((long)3L, (long)Integer.parseInt(this.readContentsOfFile(new File(version2, "currentEpoch"))));
            Assert.assertEquals((long)3L, (long)Integer.parseInt(this.readContentsOfFile(new File(version2, "acceptedEpoch"))));
        }
        finally {
            this.recursiveDelete(tmpDir);
        }
    }

    static class ConversableObserver
    extends Observer {
        QuorumPeer.QuorumServer leaderQuorumServer;

        ConversableObserver(QuorumPeer self, ObserverZooKeeperServer zk) {
            super(self, zk);
        }

        public void setLeaderQuorumServer(QuorumPeer.QuorumServer quorumServer) {
            this.leaderQuorumServer = quorumServer;
        }

        protected QuorumPeer.QuorumServer findLeader() {
            return this.leaderQuorumServer;
        }
    }

    static class ConversableFollower
    extends Follower {
        QuorumPeer.QuorumServer leaderQuorumServer;

        ConversableFollower(QuorumPeer self, FollowerZooKeeperServer zk) {
            super(self, zk);
        }

        public void setLeaderQuorumServer(QuorumPeer.QuorumServer quorumServer) {
            this.leaderQuorumServer = quorumServer;
        }

        protected QuorumPeer.QuorumServer findLeader() {
            return this.leaderQuorumServer;
        }
    }

    class TrackerWatcher
    implements Watcher {
        boolean changed;

        TrackerWatcher() {
        }

        synchronized void waitForChange() throws InterruptedException {
            while (!this.changed) {
                this.wait();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                TrackerWatcher trackerWatcher = this;
                synchronized (trackerWatcher) {
                    this.changed = true;
                    this.notifyAll();
                }
            }
        }

        public synchronized boolean changed() {
            return this.changed;
        }
    }

    public static interface ObserverConversation {
        public void converseWithObserver(InputArchive var1, OutputArchive var2, Observer var3) throws Exception;
    }

    public static interface FollowerConversation {
        public void converseWithFollower(InputArchive var1, OutputArchive var2, Follower var3) throws Exception;
    }

    public static interface PopulatedLeaderConversation {
        public void converseWithLeader(InputArchive var1, OutputArchive var2, Leader var3, long var4) throws Exception;
    }

    public static interface LeaderConversation {
        public void converseWithLeader(InputArchive var1, OutputArchive var2, Leader var3) throws Exception;
    }

    public static final class FollowerMockThread
    extends Thread {
        private final Leader leader;
        private final long followerSid;
        public long epoch = -1L;
        public String msg = null;
        private boolean onlyGetEpochToPropose;

        private FollowerMockThread(long followerSid, Leader leader, boolean onlyGetEpochToPropose) {
            this.leader = leader;
            this.followerSid = followerSid;
            this.onlyGetEpochToPropose = onlyGetEpochToPropose;
        }

        @Override
        public void run() {
            if (this.onlyGetEpochToPropose) {
                try {
                    this.epoch = this.leader.getEpochToPropose(this.followerSid, 0L);
                }
                catch (Exception exception) {}
            } else {
                try {
                    this.leader.waitForEpochAck(this.followerSid, new StateSummary(0L, 0L));
                    this.msg = "FollowerMockThread (id = " + this.followerSid + ")  returned from waitForEpochAck";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static final class LeadThread
    extends Thread {
        private final Leader leader;

        private LeadThread(Leader leader) {
            this.leader = leader;
        }

        @Override
        public void run() {
            try {
                this.leader.lead();
            }
            catch (InterruptedException e) {
                LOG.info("Leader thread interrupted", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("Unexpected exception in leader thread", (Throwable)e);
            }
            finally {
                this.leader.shutdown("lead ended");
            }
        }
    }
}

