/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Optional;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.po.GroupPO;
import org.apache.gravitino.storage.relational.po.OwnerRelPO;
import org.apache.gravitino.storage.relational.po.UserPO;
import org.apache.gravitino.storage.relational.service.EntityIdService;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwnerMetaService {
    private static final OwnerMetaService INSTANCE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;

    private OwnerMetaService() {
    }

    public static OwnerMetaService getInstance() {
        return INSTANCE;
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getOwner")
    public Optional<Entity> getOwner(NameIdentifier identifier, Entity.EntityType type) {
        NameIdentifier nameIdentifier = identifier;
        Entity.EntityType entityType = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)nameIdentifier, (Object)((Object)entityType));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = OwnerMetaService.class.getDeclaredMethod("getOwner", NameIdentifier.class, Entity.EntityType.class).getAnnotation(Monitored.class);
        }
        return (Optional)OwnerMetaService.getOwner_aroundBody1$advice(this, nameIdentifier, entityType, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="setOwner")
    public void setOwner(NameIdentifier entity, Entity.EntityType entityType, NameIdentifier owner, Entity.EntityType ownerType) {
        NameIdentifier nameIdentifier = entity;
        Entity.EntityType entityType2 = entityType;
        NameIdentifier nameIdentifier2 = owner;
        Entity.EntityType entityType3 = ownerType;
        Object[] objectArray = new Object[]{nameIdentifier, entityType2, nameIdentifier2, entityType3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = OwnerMetaService.class.getDeclaredMethod("setOwner", NameIdentifier.class, Entity.EntityType.class, NameIdentifier.class, Entity.EntityType.class).getAnnotation(Monitored.class);
        }
        OwnerMetaService.setOwner_aroundBody3$advice(this, nameIdentifier, entityType2, nameIdentifier2, entityType3, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    static {
        OwnerMetaService.ajc$preClinit();
        INSTANCE = new OwnerMetaService();
    }

    private static final /* synthetic */ Optional getOwner_aroundBody0(OwnerMetaService ajc$this, NameIdentifier identifier, Entity.EntityType type, JoinPoint joinPoint) {
        Long entityId = EntityIdService.getEntityId(identifier, type);
        UserPO userPO = SessionUtils.getWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.selectUserOwnerMetaByMetadataObjectIdAndType(entityId, type.name()));
        if (userPO != null) {
            return Optional.of(POConverters.fromUserPO(userPO, Collections.emptyList(), AuthorizationUtils.ofUserNamespace(NameIdentifierUtil.getMetalake(identifier))));
        }
        GroupPO groupPO = SessionUtils.getWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.selectGroupOwnerMetaByMetadataObjectIdAndType(entityId, type.name()));
        if (groupPO != null) {
            return Optional.of(POConverters.fromGroupPO(groupPO, Collections.emptyList(), AuthorizationUtils.ofGroupNamespace(NameIdentifierUtil.getMetalake(identifier))));
        }
        return Optional.empty();
    }

    private static final /* synthetic */ Object getOwner_aroundBody1$advice(OwnerMetaService ajc$this, NameIdentifier identifier, Entity.EntityType type, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Optional optional;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return OwnerMetaService.getOwner_aroundBody0(ajc$this, identifier, type, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return OwnerMetaService.getOwner_aroundBody0(ajc$this, identifier, type, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Optional result = OwnerMetaService.getOwner_aroundBody0(ajc$this, identifier, type, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                optional = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return optional;
    }

    private static final /* synthetic */ void setOwner_aroundBody2(OwnerMetaService ajc$this, NameIdentifier entity, Entity.EntityType entityType, NameIdentifier owner, Entity.EntityType ownerType, JoinPoint joinPoint) {
        long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(NameIdentifierUtil.getMetalake(entity));
        Long entityId = EntityIdService.getEntityId(entity, entityType);
        Long ownerId = EntityIdService.getEntityId(owner, ownerType);
        OwnerRelPO ownerRelPO = POConverters.initializeOwnerRelPOsWithVersion(metalakeId, ownerType.name(), ownerId, entityType.name(), entityId);
        SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetadataObjectIdAndType(entityId, NameIdentifierUtil.toMetadataObject(entity, entityType).type().name())), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.insertOwnerRel(ownerRelPO)));
    }

    private static final /* synthetic */ Object setOwner_aroundBody3$advice(OwnerMetaService ajc$this, NameIdentifier entity, Entity.EntityType entityType, NameIdentifier owner, Entity.EntityType ownerType, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var16_21;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                OwnerMetaService.setOwner_aroundBody2(ajc$this, entity, entityType, owner, ownerType, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                OwnerMetaService.setOwner_aroundBody2(ajc$this, entity, entityType, owner, ownerType, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                OwnerMetaService.setOwner_aroundBody2(ajc$this, entity, entityType, owner, ownerType, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var16_21 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var16_21;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwnerMetaService.java", OwnerMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOwner", "org.apache.gravitino.storage.relational.service.OwnerMetaService", "org.apache.gravitino.NameIdentifier:org.apache.gravitino.Entity$EntityType", "identifier:type", "", "java.util.Optional"), 51);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setOwner", "org.apache.gravitino.storage.relational.service.OwnerMetaService", "org.apache.gravitino.NameIdentifier:org.apache.gravitino.Entity$EntityType:org.apache.gravitino.NameIdentifier:org.apache.gravitino.Entity$EntityType", "entity:entityType:owner:ownerType", "", "void"), 89);
    }
}

