/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.authorization.RoleDTO;
import org.apache.gravitino.dto.responses.BaseResponse;

public class RoleResponse
extends BaseResponse {
    @JsonProperty(value="role")
    private final RoleDTO role;

    public RoleResponse(RoleDTO role) {
        super(0);
        this.role = role;
    }

    public RoleResponse() {
        this.role = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument((this.role != null ? 1 : 0) != 0, (Object)"role must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.role.name()), (Object)"role 'name' must not be null and empty");
        Preconditions.checkArgument((this.role.auditInfo() != null ? 1 : 0) != 0, (Object)"role 'auditInfo' must not be null");
        Preconditions.checkArgument((this.role.securableObjects() != null ? 1 : 0) != 0, (Object)"role 'securable objects' can't null");
    }

    public RoleDTO getRole() {
        return this.role;
    }

    @Override
    public String toString() {
        return "RoleResponse(role=" + String.valueOf(this.getRole()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoleResponse)) {
            return false;
        }
        RoleResponse other = (RoleResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleDTO this$role = this.getRole();
        RoleDTO other$role = other.getRole();
        return !(this$role == null ? other$role != null : !this$role.equals(other$role));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RoleResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        RoleDTO $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        return result;
    }
}

