#!/usr/bin/env bash
#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Referred from Apache Submarine's common.sh implementation
# bin/common.sh

set -e

bin="$(dirname "${BASH_SOURCE-$0}")"
bin="$(cd "${bin}">/dev/null; pwd)"

. "${bin}/common.sh"

AUXLIB_DIR="${GRAVITINO_HOME}/auxlib"

# Search strategy for finding the Gravitino CLI JAR:
if [ -z "$CLI_JAR" ]; then
    CLI_JAR=$(ls -1 "${AUXLIB_DIR}"/gravitino-cli-*.jar 2>/dev/null | sort -V | tail -n 1)
fi

if [ -z "$CLI_JAR" ]; then
    echo "ERROR: Could not find CLI jar in ${AUXLIB_DIR}"
    exit 1
fi

$JAVA_RUNNER -jar "$CLI_JAR" "$@"