/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.stats.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.lancedb.lance.Dataset;
import com.lancedb.lance.Fragment;
import com.lancedb.lance.FragmentMetadata;
import com.lancedb.lance.ReadOptions;
import com.lancedb.lance.Transaction;
import com.lancedb.lance.WriteParams;
import com.lancedb.lance.operation.Append;
import com.lancedb.lance.operation.Operation;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.stats.PartitionRange;
import org.apache.gravitino.stats.PartitionStatisticsDrop;
import org.apache.gravitino.stats.PartitionStatisticsModification;
import org.apache.gravitino.stats.PartitionStatisticsUpdate;
import org.apache.gravitino.stats.storage.MetadataObjectStatisticsDrop;
import org.apache.gravitino.stats.storage.MetadataObjectStatisticsUpdate;
import org.apache.gravitino.stats.storage.PartitionStatisticStorage;
import org.apache.gravitino.stats.storage.PersistedPartitionStatistics;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class LancePartitionStatisticStorage
implements PartitionStatisticStorage {
    private static final String LOCATION = "location";
    private static final String DEFAULT_LOCATION = String.join((CharSequence)File.separator, System.getenv("GRAVITINO_HOME"), "data", "lance");
    private static final String MAX_ROWS_PER_FILE = "maxRowsPerFile";
    private static final int DEFAULT_MAX_ROWS_PER_FILE = 1000000;
    private static final String MAX_BYTES_PER_FILE = "maxBytesPerFile";
    private static final int DEFAULT_MAX_BYTES_PER_FILE = 0x6400000;
    private static final String MAX_ROWS_PER_GROUP = "maxRowsPerGroup";
    private static final int DEFAULT_MAX_ROWS_PER_GROUP = 1000000;
    private static final String READ_BATCH_SIZE = "readBatchSize";
    private static final int DEFAULT_READ_BATCH_SIZE = 10000;
    private static final String DATASET_CACHE_SIZE = "datasetCacheSize";
    private static final int DEFAULT_DATASET_CACHE_SIZE = 0;
    private static final String METADATA_FILE_CACHE_SIZE = "metadataFileCacheSizeBytes";
    private static final long DEFAULT_METADATA_FILE_CACHE_SIZE = 102400L;
    private static final String INDEX_CACHE_SIZE = "indexCacheSizeBytes";
    private static final long DEFAULT_INDEX_CACHE_SIZE = 102400L;
    private static final String TABLE_ID_COLUMN = "table_id";
    private static final String PARTITION_NAME_COLUMN = "partition_name";
    private static final String STATISTIC_NAME_COLUMN = "statistic_name";
    private static final String STATISTIC_VALUE_COLUMN = "statistic_value";
    private static final String AUDIT_INFO_COLUMN = "audit_info";
    private final Optional<Cache<Long, Dataset>> datasetCache;
    private static final Schema SCHEMA = new Schema(Arrays.asList(Field.notNullable((String)"table_id", (ArrowType)new ArrowType.Int(64, false)), Field.notNullable((String)"partition_name", (ArrowType)new ArrowType.Utf8()), Field.notNullable((String)"statistic_name", (ArrowType)new ArrowType.Utf8()), Field.notNullable((String)"statistic_value", (ArrowType)new ArrowType.LargeUtf8()), Field.notNullable((String)"audit_info", (ArrowType)new ArrowType.Utf8())));
    private final Map<String, String> properties;
    private final String location;
    private final BufferAllocator allocator;
    private final int maxRowsPerFile;
    private final int maxBytesPerFile;
    private final int maxRowsPerGroup;
    private final int readBatchSize;
    private final long metadataFileCacheSize;
    private final long indexCacheSize;
    private final ScheduledThreadPoolExecutor scheduler;
    private final EntityStore entityStore = GravitinoEnv.getInstance().entityStore();

    public LancePartitionStatisticStorage(Map<String, String> properties) {
        this.allocator = new RootAllocator();
        this.location = properties.getOrDefault(LOCATION, DEFAULT_LOCATION);
        this.maxRowsPerFile = Integer.parseInt(properties.getOrDefault(MAX_ROWS_PER_FILE, String.valueOf(1000000)));
        Preconditions.checkArgument((this.maxRowsPerFile > 0 ? 1 : 0) != 0, (Object)"Lance partition statistics storage maxRowsPerFile must be positive");
        this.maxBytesPerFile = Integer.parseInt(properties.getOrDefault(MAX_BYTES_PER_FILE, String.valueOf(0x6400000)));
        Preconditions.checkArgument((this.maxBytesPerFile > 0 ? 1 : 0) != 0, (Object)"Lance partition statistics storage maxBytesPerFile must be positive");
        this.maxRowsPerGroup = Integer.parseInt(properties.getOrDefault(MAX_ROWS_PER_GROUP, String.valueOf(1000000)));
        Preconditions.checkArgument((this.maxRowsPerGroup > 0 ? 1 : 0) != 0, (Object)"Lance partition statistics storage maxRowsPerGroup must be positive");
        this.readBatchSize = Integer.parseInt(properties.getOrDefault(READ_BATCH_SIZE, String.valueOf(10000)));
        Preconditions.checkArgument((this.readBatchSize > 0 ? 1 : 0) != 0, (Object)"Lance partition statistics storage readBatchSize must be positive");
        int datasetCacheSize = Integer.parseInt(properties.getOrDefault(DATASET_CACHE_SIZE, String.valueOf(0)));
        Preconditions.checkArgument((datasetCacheSize >= 0 ? 1 : 0) != 0, (Object)"Lance partition statistics storage datasetCacheSize must be greater than or equal to 0");
        this.metadataFileCacheSize = Long.parseLong(properties.getOrDefault(METADATA_FILE_CACHE_SIZE, String.valueOf(102400L)));
        Preconditions.checkArgument((this.metadataFileCacheSize > 0L ? 1 : 0) != 0, (Object)"Lance partition statistics storage metadataFileCacheSizeBytes must be positive");
        this.indexCacheSize = Long.parseLong(properties.getOrDefault(INDEX_CACHE_SIZE, String.valueOf(102400L)));
        Preconditions.checkArgument((this.indexCacheSize > 0L ? 1 : 0) != 0, (Object)"Lance partition statistics storage indexCacheSizeBytes must be positive");
        this.properties = properties;
        if (datasetCacheSize != 0) {
            this.scheduler = new ScheduledThreadPoolExecutor(1, this.newDaemonThreadFactory("lance-partition-statistic-storage-cache-cleaner"));
            this.datasetCache = Optional.of(Caffeine.newBuilder().maximumSize((long)datasetCacheSize).scheduler(Scheduler.forScheduledExecutorService((ScheduledExecutorService)this.scheduler)).evictionListener((key, value, cause) -> {
                if (value != null) {
                    value.close();
                }
            }).build());
        } else {
            this.datasetCache = Optional.empty();
            this.scheduler = null;
        }
    }

    @Override
    public List<PersistedPartitionStatistics> listStatistics(String metalake, MetadataObject metadataObject, PartitionRange partitionRange) throws IOException {
        NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalake, metadataObject);
        Entity.EntityType type = MetadataObjectUtil.toEntityType(metadataObject);
        Long tableId = this.entityStore.get(identifier, type, TableEntity.class).id();
        return this.listStatisticsImpl(tableId, LancePartitionStatisticStorage.getPartitionFilter(partitionRange));
    }

    @Override
    public int dropStatistics(String metalake, List<MetadataObjectStatisticsDrop> partitionStatisticsToDrop) throws IOException {
        for (MetadataObjectStatisticsDrop objectDrop : partitionStatisticsToDrop) {
            NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalake, objectDrop.metadataObject());
            Entity.EntityType type = MetadataObjectUtil.toEntityType(objectDrop.metadataObject());
            Long tableId = this.entityStore.get(identifier, type, TableEntity.class).id();
            this.dropStatisticsImpl(tableId, objectDrop.drops());
        }
        return 1;
    }

    @Override
    public void updateStatistics(String metalake, List<MetadataObjectStatisticsUpdate> statisticsToUpdate) throws IOException {
        try {
            for (MetadataObjectStatisticsUpdate objectUpdate : statisticsToUpdate) {
                NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalake, objectUpdate.metadataObject());
                Entity.EntityType type = MetadataObjectUtil.toEntityType(objectUpdate.metadataObject());
                Long tableId = this.entityStore.get(identifier, type, TableEntity.class).id();
                List<PartitionStatisticsDrop> partitionDrops = objectUpdate.partitionUpdates().stream().map(partitionStatisticsUpdate -> PartitionStatisticsModification.drop((String)partitionStatisticsUpdate.partitionName(), (List)Lists.newArrayList(partitionStatisticsUpdate.statistics().keySet()))).collect(Collectors.toList());
                this.dropStatisticsImpl(tableId, partitionDrops);
                this.appendStatisticsImpl(tableId, objectUpdate.partitionUpdates());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendStatisticsImpl(Long tableId, List<PartitionStatisticsUpdate> updates) throws JsonProcessingException {
        Dataset datasetRead = null;
        Dataset newDataset = null;
        try {
            datasetRead = this.getDataset(tableId);
            List<FragmentMetadata> fragmentMetas = this.createFragmentMetadata(tableId, updates);
            Transaction appendTxn = datasetRead.newTransactionBuilder().operation((Operation)Append.builder().fragments(fragmentMetas).build()).transactionProperties(Collections.emptyMap()).build();
            Dataset finalNewDataset = newDataset = appendTxn.commit();
            this.datasetCache.ifPresent(cache -> cache.put((Object)tableId, (Object)finalNewDataset));
        }
        finally {
            if (!this.datasetCache.isPresent()) {
                if (datasetRead != null) {
                    datasetRead.close();
                }
                if (newDataset != null) {
                    newDataset.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropStatisticsImpl(Long tableId, List<PartitionStatisticsDrop> drops) {
        Dataset dataset = this.getDataset(tableId);
        try {
            ArrayList partitionSQLs = Lists.newArrayList();
            for (PartitionStatisticsDrop drop : drops) {
                List statistics = drop.statisticNames();
                String partition = drop.partitionName();
                partitionSQLs.add("table_id = " + tableId + " AND partition_name = '" + partition + "' AND statistic_name IN (" + statistics.stream().map(str -> "'" + str + "'").collect(Collectors.joining(", ")) + ")");
            }
            if (partitionSQLs.size() == 1) {
                dataset.delete((String)partitionSQLs.get(0));
            } else if (partitionSQLs.size() > 1) {
                String filterSQL = partitionSQLs.stream().map(str -> "(" + str + ")").collect(Collectors.joining(" OR "));
                dataset.delete(filterSQL);
            }
        }
        finally {
            if (!this.datasetCache.isPresent() && dataset != null) {
                dataset.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.allocator != null) {
            this.allocator.close();
        }
        this.datasetCache.ifPresent(Cache::invalidateAll);
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    @VisibleForTesting
    Cache<Long, Dataset> getDatasetCache() {
        return this.datasetCache.orElse(null);
    }

    private String getFilePath(Long tableId) {
        return this.location + "/" + tableId + ".lance";
    }

    private List<FragmentMetadata> createFragmentMetadata(Long tableId, List<PartitionStatisticsUpdate> updates) throws JsonProcessingException {
        int count = 0;
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)SCHEMA, (BufferAllocator)this.allocator);){
            for (PartitionStatisticsUpdate update : updates) {
                count += update.statistics().size();
            }
            for (FieldVector vector : root.getFieldVectors()) {
                vector.setInitialCapacity(count);
            }
            root.allocateNew();
            int index = 0;
            UInt8Vector tableIdVector = (UInt8Vector)root.getVector(TABLE_ID_COLUMN);
            VarCharVector partitionNameVector = (VarCharVector)root.getVector(PARTITION_NAME_COLUMN);
            VarCharVector statisticNameVector = (VarCharVector)root.getVector(STATISTIC_NAME_COLUMN);
            LargeVarCharVector statisticValueVector = (LargeVarCharVector)root.getVector(STATISTIC_VALUE_COLUMN);
            VarCharVector auditInfoVector = (VarCharVector)root.getVector(AUDIT_INFO_COLUMN);
            for (PartitionStatisticsUpdate updatePartitionStatistic : updates) {
                String partitionName = updatePartitionStatistic.partitionName();
                for (Map.Entry statistic : updatePartitionStatistic.statistics().entrySet()) {
                    String statisticName = (String)statistic.getKey();
                    String statisticValue = JsonUtils.anyFieldMapper().writeValueAsString(statistic.getValue());
                    tableIdVector.set(index, tableId.longValue());
                    partitionNameVector.setSafe(index, partitionName.getBytes(StandardCharsets.UTF_8));
                    statisticNameVector.setSafe(index, statisticName.getBytes(StandardCharsets.UTF_8));
                    statisticValueVector.setSafe(index, statisticValue.getBytes(StandardCharsets.UTF_8));
                    AuditInfo auditInfo = AuditInfo.builder().withCreator(PrincipalUtils.getCurrentUserName()).withCreateTime(Instant.now()).withLastModifier(PrincipalUtils.getCurrentUserName()).withLastModifiedTime(Instant.now()).build();
                    auditInfoVector.setSafe(index, JsonUtils.anyFieldMapper().writeValueAsString((Object)auditInfo).getBytes(StandardCharsets.UTF_8));
                    ++index;
                }
            }
            root.setRowCount(index);
            List fragmentMetas = Fragment.create((String)this.getFilePath(tableId), (BufferAllocator)this.allocator, (VectorSchemaRoot)root, (WriteParams)new WriteParams.Builder().withMaxRowsPerFile(this.maxRowsPerFile).withMaxBytesPerFile((long)this.maxBytesPerFile).withMaxRowsPerGroup(this.maxRowsPerGroup).withStorageOptions(this.properties).build());
            List list = fragmentMetas;
            return list;
        }
    }

    private static String getPartitionFilter(PartitionRange range) {
        String fromPartitionNameFilter = range.lowerPartitionName().flatMap(name -> range.lowerBoundType().map(type -> "AND partition_name " + (type == PartitionRange.BoundType.CLOSED ? ">= " : "> ") + "'" + name + "'")).orElse("");
        String toPartitionNameFilter = range.upperPartitionName().flatMap(name -> range.upperBoundType().map(type -> "AND partition_name " + (type == PartitionRange.BoundType.CLOSED ? "<= " : "< ") + "'" + name + "'")).orElse("");
        return fromPartitionNameFilter + toPartitionNameFilter;
    }

    /*
     * Exception decompiling
     */
    private List<PersistedPartitionStatistics> listStatisticsImpl(Long tableId, String partitionFilter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Dataset getDataset(Long tableId) {
        AtomicBoolean newlyCreated = new AtomicBoolean(false);
        return this.datasetCache.map(cache -> {
            Dataset cachedDataset = (Dataset)cache.get((Object)tableId, id -> {
                newlyCreated.set(true);
                return this.open(this.getFilePath((Long)id));
            });
            if (!newlyCreated.get()) {
                cachedDataset.checkoutLatest();
            }
            return cachedDataset;
        }).orElse(this.open(this.getFilePath(tableId)));
    }

    private Dataset open(String fileName) {
        try {
            return Dataset.open((BufferAllocator)this.allocator, (String)fileName, (ReadOptions)new ReadOptions.Builder().setMetadataCacheSizeBytes(this.metadataFileCacheSize).setIndexCacheSizeBytes(this.indexCacheSize).build());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage().contains("was not found")) {
                return Dataset.create((BufferAllocator)this.allocator, (String)fileName, (Schema)SCHEMA, (WriteParams)new WriteParams.Builder().build());
            }
            throw illegalArgumentException;
        }
    }

    private ThreadFactory newDaemonThreadFactory(String name) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(name + "-%d").build();
    }

    private static /* synthetic */ PersistedPartitionStatistics lambda$listStatisticsImpl$10(Map.Entry entry) {
        return PersistedPartitionStatistics.of((String)entry.getKey(), (List)entry.getValue());
    }

    private static /* synthetic */ List lambda$listStatisticsImpl$9(String k) {
        return Lists.newArrayList();
    }
}

