/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.fs.contract.localfs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.contract.AbstractContractMultipartUploaderTest;
import org.apache.hadoop.fs.contract.AbstractFSContract;

/**
 * Test the FileSystemMultipartUploader on local file system.
 */
public class TestLocalFSContractMultipartUploader
    extends AbstractContractMultipartUploaderTest {

  @Override
  protected AbstractFSContract createContract(Configuration conf) {
    return new LocalFSContract(conf);
  }

  /**
   * There is no real need to upload any particular size.
   * @return 1 kilobyte
   */
  @Override
  protected int partSizeInBytes() {
    return 1024;
  }

  @Override
  protected boolean finalizeConsumesUploadIdImmediately() {
    return true;
  }

  @Override
  protected boolean supportsConcurrentUploadsToSamePath() {
    return true;
  }
}
